/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.noear.solon.core.util.IgnoreCaseMap;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.lang.Nullable;

public class MultiMap<T>
implements Iterable<KeyValues<T>>,
Serializable {
    protected final Map<String, KeyValues<T>> innerMap;
    protected final boolean ignoreCase;

    public MultiMap() {
        this(true);
    }

    public MultiMap(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.innerMap = this.createMap(0);
    }

    @Override
    public Iterator<KeyValues<T>> iterator() {
        return this.innerMap.values().iterator();
    }

    public KeyValues<T> holder(String key) {
        return this.innerMap.computeIfAbsent(key, k -> new KeyValues(key));
    }

    public Set<String> keySet() {
        return this.innerMap.keySet();
    }

    public boolean containsKey(String key) {
        return this.innerMap.containsKey(key);
    }

    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    public int size() {
        return this.innerMap.size();
    }

    public void put(String key, T val) {
        this.holder(key).setValues(val);
    }

    public void putIfAbsent(String key, T val) {
        if (!this.innerMap.containsKey(key)) {
            this.holder(key).setValues(val);
        }
    }

    public void putAll(Map<String, T> values) {
        for (Map.Entry<String, T> entry : values.entrySet()) {
            this.holder(entry.getKey()).setValues(entry.getValue());
        }
    }

    public void add(String key, T val) {
        this.holder(key).addValue(val);
    }

    public void addAll(Map<String, T> values) {
        for (Map.Entry<String, T> entry : values.entrySet()) {
            this.holder(entry.getKey()).addValue(entry.getValue());
        }
    }

    public void remove(String key) {
        this.innerMap.remove(key);
    }

    public void clear() {
        this.innerMap.clear();
    }

    @Nullable
    public List<T> getAll(String key) {
        KeyValues<T> tmp = this.innerMap.get(key);
        if (tmp == null) {
            return null;
        }
        return tmp.getValues();
    }

    @Nullable
    public T get(String key) {
        KeyValues<T> tmp = this.innerMap.get(key);
        if (tmp == null) {
            return null;
        }
        return tmp.getFirstValue();
    }

    @Nullable
    public T getOrDefault(String key, T def) {
        T tmp = this.get(key);
        return tmp == null ? def : tmp;
    }

    public Map<String, T> toValueMap() {
        Map<String, T> tmp = this.createMap(this.size());
        for (KeyValues<T> kv : this.innerMap.values()) {
            tmp.put(kv.getKey(), kv.getFirstValue());
        }
        return tmp;
    }

    public Map<String, List<T>> toValuesMap() {
        Map<String, List<T>> tmp = this.createMap(this.size());
        for (KeyValues<T> kv : this.innerMap.values()) {
            tmp.put(kv.getKey(), kv.getValues());
        }
        return tmp;
    }

    protected <V> Map<String, V> createMap(int size) {
        if (this.ignoreCase) {
            if (size > 0) {
                return new IgnoreCaseMap(size);
            }
            return new IgnoreCaseMap();
        }
        if (size > 0) {
            return new LinkedHashMap(size);
        }
        return new LinkedHashMap();
    }

    public String toString() {
        return this.innerMap.values().toString();
    }

    public static MultiMap<String> from(String[] args) {
        MultiMap<String> d = new MultiMap<String>();
        if (args != null) {
            for (String arg : args) {
                int index = arg.indexOf(61);
                if (index > 0) {
                    String name = arg.substring(0, index);
                    String value = arg.substring(index + 1);
                    d.add(name.replaceAll("^-*", ""), value);
                    continue;
                }
                d.add(arg.replaceAll("^-*", ""), "");
            }
        }
        return d;
    }

    public MultiMap then(Consumer<MultiMap<T>> consumer) {
        consumer.accept(this);
        return this;
    }
}

