/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.ConstrEggg;
import org.noear.eggg.FieldEggg;
import org.noear.eggg.ParamEggg;
import org.noear.eggg.TypeEggg;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.exception.ConstructionException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.core.util.EgggUtil;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.core.wrap.VarSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtil {
    static Logger log = LoggerFactory.getLogger(ClassUtil.class);
    private static final ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
    private static Predicate<Class<?>> SCAN_CLASSES_FILTER_DEF = clz -> true;

    public static boolean isNumberType(Class<?> clz) {
        if (clz.isPrimitive()) {
            return clz == Byte.TYPE || clz == Short.TYPE || clz == Integer.TYPE || clz == Long.TYPE || clz == Float.TYPE || clz == Double.TYPE;
        }
        return Number.class.isAssignableFrom(clz);
    }

    public static void accessibleAsTrue(AccessibleObject target) {
        try {
            if (!target.isAccessible()) {
                target.setAccessible(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean hasClass(SupplierEx<Class<?>> test) {
        try {
            test.get();
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static Class<?> loadClass(String className) {
        return ClassUtil.loadClass(null, className);
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            if (classLoader == null) {
                return Class.forName(className);
            }
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    public static <T> T tryInstance(String className) {
        return ClassUtil.tryInstance(className, null);
    }

    public static <T> T tryInstance(String className, Properties prop) {
        return ClassUtil.tryInstance(AppClassLoader.global(), className, prop);
    }

    public static <T> T tryInstance(ClassLoader classLoader, String className) {
        return ClassUtil.tryInstance(classLoader, className, null);
    }

    public static <T> T tryInstance(ClassLoader classLoader, String className, Properties prop) {
        Class<?> clz = ClassUtil.loadClass(classLoader, className);
        return ClassUtil.tryInstance(clz, prop);
    }

    public static <T> T tryInstance(Class<?> clz, Properties prop) {
        if (clz == null) {
            return null;
        }
        return ClassUtil.newInstance(clz, prop);
    }

    public static <T> T newInstance(Class<?> clz) throws ConstructionException {
        return ClassUtil.newInstance(clz, null);
    }

    public static <T> T newInstance(Class<?> clz, Properties prop) throws ConstructionException {
        try {
            if (prop == null) {
                return (T)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (T)clz.getConstructor(Properties.class).newInstance(prop);
        }
        catch (Exception e) {
            throw new ConstructionException("Instantiation failure: " + clz.getName(), e);
        }
    }

    public static Object newInstance(Class<?> clz, Class<?>[] types, Object[] args) {
        try {
            Constructor<?> constructor = clz.getDeclaredConstructor(types);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new ConstructionException("Instantiation failure: " + clz.getName(), e);
        }
    }

    public static Object newInstance(Constructor constructor, Object[] args) {
        if (constructor == null) {
            throw new IllegalArgumentException("constructor is null");
        }
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new ConstructionException("Instantiation failure: " + constructor.getDeclaringClass().getName(), e);
        }
    }

    public static ClassLoader resolveClassLoader(Type type) {
        ClassLoader cl;
        Class<?> clz;
        ClassLoader loader = AppClassLoader.global();
        if (type != null && (clz = ClassUtil.getTypeClass(type)) != Object.class && (cl = clz.getClassLoader()) != systemClassLoader) {
            loader = cl;
        }
        return loader;
    }

    public static Class<?> getTypeClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtil.getTypeClass(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }

    public static boolean equalParamTypes(Class<?>[] params1, Class<?>[] params2) {
        if (params1.length == params2.length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static Collection<Method> findPublicMethods(Class<?> clz) {
        throw new UnsupportedOperationException();
    }

    public static Collection<Class<?>> scanClasses(String clzExpr) {
        return ClassUtil.scanClasses(AppClassLoader.global(), clzExpr, SCAN_CLASSES_FILTER_DEF);
    }

    public static Collection<Class<?>> scanClasses(String clzExpr, Predicate<Class<?>> clzFilter) {
        return ClassUtil.scanClasses(AppClassLoader.global(), clzExpr, clzFilter);
    }

    public static Collection<Class<?>> scanClasses(ClassLoader classLoader, String clzExpr) {
        return ClassUtil.scanClasses(classLoader, clzExpr, SCAN_CLASSES_FILTER_DEF);
    }

    public static Collection<Class<?>> scanClasses(ClassLoader classLoader, String clzExpr, Predicate<Class<?>> clzFilter) {
        int idx;
        ArrayList clzList = new ArrayList();
        if (clzExpr.indexOf(42) < 0) {
            if (clzExpr.endsWith(".class")) {
                Class<?> clz = ClassUtil.loadClass(classLoader, clzExpr = clzExpr.substring(0, clzExpr.length() - 6));
                if (clz != null && clzFilter.test(clz)) {
                    clzList.add(clz);
                }
                return clzList;
            }
            idx = clzExpr.lastIndexOf(46);
            if (idx > 0 && Character.isLowerCase(clzExpr.charAt(idx + 1))) {
                clzExpr = clzExpr + ".*";
            } else {
                Class<?> clz = ClassUtil.loadClass(classLoader, clzExpr);
                if (clz != null && clzFilter.test(clz)) {
                    clzList.add(clz);
                }
                return clzList;
            }
        }
        if (clzExpr.endsWith(".class")) {
            clzExpr = clzExpr.substring(0, clzExpr.length() - 6);
        } else {
            idx = clzExpr.lastIndexOf(46);
            if (idx > 0 && clzExpr.indexOf(42, idx) < 0 && Character.isLowerCase(clzExpr.charAt(idx + 1))) {
                clzExpr = clzExpr + ".*";
            }
        }
        clzExpr = clzExpr.replace('.', '/');
        clzExpr = clzExpr + ".class";
        ResourceUtil.scanResources(classLoader, clzExpr).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class<?> clz = ClassUtil.loadClass(classLoader, className = className.replace('/', '.'));
            if (clz != null && clzFilter.test(clz)) {
                clzList.add(clz);
            }
        });
        return clzList;
    }

    public static void fillObject(Object bean, Function<String, String> data) {
        try {
            ClassUtil.doFillObject(EgggUtil.getTypeEggg(bean.getClass()), bean, data, null);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void doFillObject(TypeEggg typeEggg, Object bean, Function<String, String> data, Context ctx) throws Exception {
        ClassEggg classEggg = typeEggg.getClassEggg();
        if (classEggg.getAllFieldEgggs().isEmpty() && NativeDetector.inNativeImage()) {
            log.warn(String.format("Class: %s don't have any field, can't fill data. you should use: nativeMetadata.registerField(field) at aot runtime.", typeEggg.getType().getName()));
        }
        for (FieldEggg fe : classEggg.getAllFieldEgggs()) {
            UploadedFile[] files1;
            String key = fe.getAlias();
            String val0 = data.apply(key);
            if (val0 != null) {
                Object val = ConvertUtil.to((VarSpec)fe.getDigest(), val0, ctx);
                fe.setValue(bean, val, true);
                continue;
            }
            if (ctx == null) continue;
            if (fe.getType() == UploadedFile.class) {
                UploadedFile file1 = ctx.file(key);
                if (file1 == null) continue;
                fe.setValue(bean, (Object)file1, true);
                continue;
            }
            if (fe.getType() != UploadedFile[].class || (files1 = ctx.fileValues(key)) == null) continue;
            fe.setValue(bean, (Object)files1, true);
        }
    }

    public static <T> T makeObject(Class<?> clz, Properties data) {
        try {
            ConstrEggg constrEggg = EgggUtil.getClassEggg(clz).findConstrEgggOrNull(new Class[]{Properties.class});
            if (constrEggg != null) {
                return (T)constrEggg.newInstance(new Object[]{data});
            }
        }
        catch (Throwable throwable) {
        }
        return ClassUtil.makeObject(clz, data::getProperty);
    }

    public static <T> T makeObject(Class<?> clz, Function<String, String> data) {
        try {
            return ClassUtil.makeObject(clz, data, null);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T makeObject(Class<?> clz, Function<String, String> data, Context ctx) throws Exception {
        ClassEggg classEggg = EgggUtil.getClassEggg(clz);
        if (classEggg.isRealRecordClass() || classEggg.isLikeRecordClass()) {
            List argsP = classEggg.getCreator().getParamEgggAry();
            Object[] argsV = new Object[argsP.size()];
            for (int i = 0; i < argsP.size(); ++i) {
                Object val;
                ParamEggg p = (ParamEggg)argsP.get(i);
                String key = ((VarSpec)p.getDigest()).getName();
                String val0 = data.apply(key);
                argsV[i] = val0 != null ? (val = ConvertUtil.to((VarSpec)p.getDigest(), val0, ctx)) : (p.getType() == UploadedFile.class ? ctx.file(key) : null);
            }
            Object obj = classEggg.getCreator().newInstance(argsV);
            return (T)obj;
        }
        Object obj = classEggg.getCreator().newInstance(new Object[0]);
        ClassUtil.doFillObject(classEggg.getTypeEggg(), obj, data, ctx);
        return (T)obj;
    }
}

