/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.DownloadedFile;
import org.noear.solon.core.handle.Entity;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderFactory;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.LogUtil;

public class RenderManager
implements Render {
    private final Map<String, Render> _mapping = new HashMap<String, Render>();
    private final Map<String, Render> _lib = new HashMap<String, Render>();
    private Render _def = (d, c) -> {
        if (d != null) {
            c.output(d.toString());
        }
    };

    public Render get(String name) {
        Render tmp = this._lib.get(name);
        if (tmp == null) {
            tmp = this._mapping.get(name);
        }
        return tmp;
    }

    public void register(RenderFactory renderFactory) {
        Render render = renderFactory.create();
        for (String mapping : renderFactory.mappings()) {
            this.register(mapping, render);
        }
    }

    public void register(String mapping, Render render) {
        if (render == null) {
            return;
        }
        if (Utils.isEmpty(mapping)) {
            this._def = render;
            this._lib.put(render.getClass().getSimpleName(), render);
            this._lib.put(render.getClass().getName(), render);
            LogUtil.global().info("View: load: " + render.getClass().getSimpleName());
            LogUtil.global().info("View: load: " + render.getClass().getName());
        } else {
            this._mapping.put(mapping, render);
            LogUtil.global().info("Render mapping: " + mapping + "=" + render.name());
        }
    }

    public void register(String mapping, String clzName) {
        if (mapping == null || clzName == null) {
            return;
        }
        Render render = this._lib.get(clzName);
        if (render == null) {
            LogUtil.global().warn("Render: " + clzName + " not exists!");
            return;
        }
        this._mapping.put(mapping, render);
        LogUtil.global().info("Render mapping: " + mapping + "=" + clzName);
    }

    public String renderAndReturn(ModelAndView modelAndView) {
        try {
            return this.renderAndReturn(modelAndView, Context.current());
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap(ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String renderAndReturn(Object data, Context ctx) throws Throwable {
        Render render;
        if (data instanceof Entity) {
            data = ((Entity)((Object)data)).body();
        }
        if (data instanceof ModelAndView) {
            ModelAndView mv = (ModelAndView)((Object)data);
            if (Utils.isNotEmpty(mv.view())) {
                return this.getViewRender(ctx, mv).renderAndReturn(mv, ctx);
            }
            data = mv.model();
        }
        if ((render = this.resolveRander(ctx)) != null) {
            return render.renderAndReturn(data, ctx);
        }
        return this._def.renderAndReturn(data, ctx);
    }

    @Override
    public void render(Object data, Context ctx) throws Throwable {
        if (data instanceof DataThrowable) {
            return;
        }
        if (data instanceof Entity) {
            Entity entity = (Entity)((Object)data);
            data = entity.body();
            if (!ctx.isHeadersSent()) {
                if (entity.status() > 0) {
                    ctx.status(entity.status());
                }
                if (!entity.headers().isEmpty()) {
                    for (KeyValues<String> keyValues : entity.headers()) {
                        if (!Utils.isNotEmpty(keyValues.getValues())) continue;
                        if (keyValues.getValues().size() > 1) {
                            for (String val : keyValues.getValues()) {
                                ctx.headerAdd(keyValues.getKey(), val);
                            }
                            continue;
                        }
                        ctx.headerSet(keyValues.getKey(), keyValues.getFirstValue());
                    }
                }
            }
        }
        if (data instanceof ModelAndView) {
            ModelAndView mv = (ModelAndView)((Object)data);
            if (Utils.isNotEmpty(mv.view())) {
                this.getViewRender(ctx, mv).render(mv, ctx);
                return;
            }
            data = mv.model();
        }
        if (data instanceof File) {
            ctx.outputAsFile((File)((Object)data));
            return;
        }
        if (data instanceof DownloadedFile) {
            ctx.outputAsFile((DownloadedFile)((Object)data));
            return;
        }
        if (data instanceof InputStream) {
            ctx.output((InputStream)((Object)data));
            return;
        }
        Render render = this.resolveRander(ctx);
        if (render != null) {
            render.render(data, ctx);
        } else {
            this._def.render(data, ctx);
        }
    }

    private Render getViewRender(Context ctx, ModelAndView mv) {
        String suffix;
        Render render;
        if (mv.view().contains("../") || mv.view().contains("..\\")) {
            throw new IllegalStateException("Invalid view path: '" + mv.view() + "'");
        }
        int suffix_idx = mv.view().lastIndexOf(".");
        if (suffix_idx > 0 && (render = this._mapping.get(suffix = mv.view().substring(suffix_idx))) != null) {
            for (Map.Entry<String, Object> kv : ctx.attrMap().entrySet()) {
                mv.putIfAbsent(kv.getKey(), kv.getValue());
            }
            return render;
        }
        return this._def;
    }

    private Render resolveRander(Context ctx) {
        Render render = null;
        String mode = ctx.header("X-Serialization");
        if (Utils.isEmpty(mode)) {
            mode = (String)ctx.attr("@render");
        }
        if (!Utils.isEmpty(mode) && (render = this._mapping.get(mode)) == null) {
            ctx.headerSet("Solon.serialization.mode", "Not supported " + mode);
        }
        if (render == null) {
            String mime2;
            String mime1 = ctx.contentTypeNew();
            for (Render r : this._mapping.values()) {
                if (!r.matched(ctx, mime1)) continue;
                render = r;
                break;
            }
            if (render == null && !Objects.equals(mime2 = ctx.acceptNew(), mime1)) {
                for (Render r : this._mapping.values()) {
                    if (!r.matched(ctx, mime2)) continue;
                    render = r;
                    break;
                }
            }
        }
        if (render == null) {
            render = ctx.remoting() ? this._mapping.get("@type_json") : this._mapping.get("@json");
        }
        return render;
    }
}

