/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.route.RoutingTable;
import org.noear.solon.core.util.RankEntity;

public class RoutingTableDefault<T>
implements RoutingTable<T> {
    private List<RankEntity<Routing<T>>> table = new ArrayList<RankEntity<Routing<T>>>();

    @Override
    public void add(Routing<T> routing) {
        int level = 0;
        if (routing.path().indexOf(123) >= 0) {
            level = 1;
        }
        if (routing.path().indexOf(42) >= 0) {
            level = 2;
        }
        RankEntity<Routing<T>> entity = new RankEntity<Routing<T>>(routing, level, routing.index(), false);
        this.table.add(entity);
        if (level != 0 || routing.index() != 0) {
            Collections.sort(this.table);
        }
    }

    @Override
    public void remove(String pathPrefix) {
        this.table.removeIf(l -> ((Routing)l.target).path().startsWith(pathPrefix));
    }

    @Override
    public void remove(Class<?> controllerClz) {
        this.table.removeIf(l -> {
            Action a;
            return ((Routing)l.target).target() instanceof Action && (a = (Action)((Routing)l.target).target()).controller().clz().equals(controllerClz);
        });
    }

    @Override
    public int count() {
        return this.table.size();
    }

    @Override
    public Collection<Routing<T>> getAll() {
        return this.table.stream().map(l -> (Routing)l.target).collect(Collectors.toList());
    }

    @Override
    public Collection<Routing<T>> getBy(String path) {
        return this.table.stream().filter(l -> ((Routing)l.target).test(path)).map(l -> (Routing)l.target).collect(Collectors.toList());
    }

    @Override
    public Collection<Routing<T>> getBy(Class<?> controllerClz) {
        return this.table.stream().filter(l -> {
            Action a;
            return ((Routing)l.target).target() instanceof Action && (a = (Action)((Routing)l.target).target()).controller().clz().equals(controllerClz);
        }).map(l -> (Routing)l.target).collect(Collectors.toList());
    }

    @Override
    public T matchOne(String path, MethodType method) {
        for (RankEntity<Routing<T>> l : this.table) {
            if (!((Routing)l.target).matches(method, path)) continue;
            return ((Routing)l.target).target();
        }
        return null;
    }

    @Override
    public Result<T> matchOneAndStatus(String path, MethodType method) {
        int degrees = 0;
        for (RankEntity<Routing<T>> l : this.table) {
            int tmp = ((Routing)l.target).degrees(method, path);
            if (tmp == 2) {
                return Result.succeed(((Routing)l.target).target());
            }
            if (tmp <= degrees) continue;
            degrees = tmp;
        }
        if (degrees == 1) {
            return Result.failure(405);
        }
        return Result.failure(404);
    }

    @Override
    public List<T> matchMore(String path, MethodType method) {
        return this.table.stream().filter(l -> ((Routing)l.target).matches(method, path)).map(l -> ((Routing)l.target).target()).collect(Collectors.toList());
    }

    @Override
    public void clear() {
        this.table.clear();
    }
}

