/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.annotation.Singleton;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrapLifecycle;
import org.noear.solon.core.exception.ConstructionException;
import org.noear.solon.core.util.ClassUtil;

public class BeanWrap {
    private Class<?> clz;
    private BeanWrapLifecycle lifecycle;
    private Constructor rawCon;
    private Object[] rawConArgs;
    private Object raw;
    private Object rawUnproxied;
    private Class<?> rawClz;
    private boolean singleton;
    private boolean remoting;
    private String name;
    private int index;
    private String tag;
    private boolean typed;
    private Proxy proxy;
    private final Annotation[] annotations;
    private final AppContext context;
    private Set<String> genericList;

    protected Set<String> genericList() {
        if (this.genericList == null) {
            this.genericList = new HashSet<String>();
        }
        return this.genericList;
    }

    public BeanWrap(AppContext context, Class<?> clz) {
        this(context, clz, null);
    }

    public BeanWrap(AppContext context, Class<?> clz, Object raw) {
        this(context, clz, raw, null);
    }

    public BeanWrap(AppContext context, Class<?> clz, Object raw, String name) {
        this(context, clz, raw, name, false, null, null);
    }

    public BeanWrap(AppContext context, Class<?> clz, Object raw, String name, boolean typed) {
        this(context, clz, raw, name, typed, null, null);
    }

    public BeanWrap(AppContext context, Class<?> clz, Object raw, String name, boolean typed, String initMethodName, String destroyMethodName) {
        this(context, clz, raw, name, typed, initMethodName, destroyMethodName, null, null);
    }

    public BeanWrap(AppContext context, Class<?> clz, Constructor rawCon, Object[] rawConArgs) {
        this(context, clz, null, null, false, null, null, rawCon, rawConArgs);
    }

    public BeanWrap(AppContext context, Class<?> clz, Object raw, String name, boolean typed, String initMethodName, String destroyMethodName, Constructor rawCon, Object[] rawConArgs) {
        this.context = context;
        this.clz = clz;
        this.name = name;
        this.typed = typed;
        this.rawCon = rawCon;
        this.rawConArgs = rawConArgs;
        Singleton anoS = clz.getAnnotation(Singleton.class);
        this.singleton = anoS == null || anoS.value();
        this.annotations = clz.getAnnotations();
        this.raw = raw == null ? (this.rawUnproxied = this._new()) : (this.rawUnproxied = raw);
        if (this.rawUnproxied != null) {
            this.rawClz = this.rawUnproxied.getClass();
        }
        this.tryInit(initMethodName, destroyMethodName);
    }

    public AppContext context() {
        return this.context;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public void proxySet(Proxy proxy) {
        this.proxy = proxy;
        if (this.raw != null) {
            this.raw = proxy.getProxy(this.context(), this.raw, this.rawCon, this.rawConArgs);
        }
    }

    public boolean singleton() {
        return this.singleton;
    }

    public void singletonSet(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean remoting() {
        return this.remoting;
    }

    public void remotingSet(boolean remoting) {
        this.remoting = remoting;
    }

    public Class<?> clz() {
        return this.clz;
    }

    public Method clzInit() {
        return this.lifecycle.initMethod();
    }

    public Method clzDestroy() {
        return this.lifecycle.destroyMethod();
    }

    public <T> T raw(boolean unproxied) {
        if (unproxied) {
            return (T)this.rawUnproxied;
        }
        return (T)this.raw;
    }

    public <T> T raw() {
        return this.raw(false);
    }

    public void rawSet(Object raw) {
        if (this.raw == null) {
            this.raw = raw;
        }
    }

    public Class<?> rawClz() {
        if (this.rawClz == null) {
            return this.clz;
        }
        return this.rawClz;
    }

    public String name() {
        return this.name;
    }

    protected void nameSet(String name) {
        this.name = name;
    }

    public int index() {
        return this.index;
    }

    protected void indexSet(int index) {
        this.index = index;
    }

    public String tag() {
        return this.tag;
    }

    protected void tagSet(String tag) {
        if (this.tag == null) {
            this.tag = tag;
        }
    }

    public boolean typed() {
        return this.typed;
    }

    protected void typedSet(boolean typed) {
        this.typed = typed;
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    public <T extends Annotation> T annotationGet(Class<T> annClz) {
        return this.clz.getAnnotation(annClz);
    }

    public <T> T get() {
        return this.get(false);
    }

    public <T> T get(boolean unproxied) {
        if (unproxied) {
            if (this.singleton) {
                return (T)this.rawUnproxied;
            }
            return (T)this._new();
        }
        if (this.singleton) {
            return (T)this.raw;
        }
        Object tmp = this._new();
        if (this.proxy != null) {
            tmp = this.proxy.getProxy(this.context(), tmp, this.rawCon, this.rawConArgs);
        }
        return (T)tmp;
    }

    public <T> T create() {
        Object tmp = this._new();
        if (this.proxy != null) {
            tmp = this.proxy.getProxy(this.context(), tmp, this.rawCon, this.rawConArgs);
        }
        return (T)tmp;
    }

    protected Object _new() throws ConstructionException {
        if (this.clz.isInterface() || this.clz.isAnonymousClass()) {
            return this.raw;
        }
        try {
            if (this.rawCon == null) {
                this.rawCon = this.clz.getDeclaredConstructor(new Class[0]);
                this.rawConArgs = new Object[0];
            }
            Object bean = ClassUtil.newInstance(this.rawCon, this.rawConArgs);
            this.context.beanInject(bean);
            return bean;
        }
        catch (Throwable e) {
            if (e instanceof ConstructionException) {
                throw (ConstructionException)e;
            }
            throw new ConstructionException("Instantiation failure: " + this.clz.getTypeName(), e);
        }
    }

    protected void tryInit(String initMethodName, String destroyMethodName) {
        if (this.lifecycle == null) {
            this.lifecycle = new BeanWrapLifecycle(this, initMethodName, destroyMethodName);
            if (this.lifecycle.check()) {
                this.context.lifecycle(this.lifecycle.index() + 1, this.lifecycle);
            }
        }
    }

    @FunctionalInterface
    public static interface Supplier {
        public Object get();
    }

    @FunctionalInterface
    public static interface Proxy {
        public Object getProxy(AppContext var1, Object var2, Constructor var3, Object[] var4);
    }
}

