/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ChainManager;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerSlots;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.route.Router;
import org.noear.solon.core.route.RouterDefault;
import org.noear.solon.core.route.RouterHandler;
import org.noear.solon.core.route.RouterInterceptor;

public abstract class RouterWrapper
implements HandlerSlots {
    private Router _router;
    private RouterHandler _routerHandler;
    private ChainManager _chainManager;

    public abstract AppContext context();

    protected void initRouter(SolonApp app) {
        this._chainManager = new ChainManager(app);
        this._router = new RouterDefault();
        this._routerHandler = new RouterHandler(this._router, this._chainManager);
    }

    protected RouterHandler routerHandler() {
        return this._routerHandler;
    }

    public Router router() {
        return this._router;
    }

    public ChainManager chainManager() {
        return this._chainManager;
    }

    public void filter(Filter filter) {
        this.filter(0, filter);
    }

    public void filter(int index, Filter filter) {
        this._chainManager.addFilter(filter, index);
    }

    public void filterIfAbsent(int index, Filter filter) {
        this._chainManager.addFilterIfAbsent(filter, index);
    }

    public void routerInterceptor(RouterInterceptor interceptor) {
        this._chainManager.addInterceptor(interceptor, 0);
    }

    public void routerInterceptor(int index, RouterInterceptor interceptor) {
        this._chainManager.addInterceptor(interceptor, index);
    }

    public void routerInterceptorIfAbsent(int index, RouterInterceptor interceptor) {
        this._chainManager.addInterceptorIfAbsent(interceptor, index);
    }

    public void render(String name, Render render) {
        Solon.app().renderManager().register(name, render);
    }

    public Render render(String name) {
        return Solon.app().renderManager().get(name);
    }

    public Render renderOfJson() {
        return this.render("@json");
    }

    @Override
    public void add(String expr, MethodType method, Handler handler) {
        this._router.add(expr, method, handler);
    }

    public void add(String expr, Class<?> clz) {
        BeanWrap bw = this.context().wrapAndPut(clz);
        this._router.add(expr, bw);
    }

    public void add(String expr, Class<?> clz, boolean remoting) {
        BeanWrap bw = this.context().wrapAndPut(clz);
        bw.remotingSet(remoting);
        this._router.add(expr, bw);
    }

    public void all(String path, Handler handler) {
        this.add(path, MethodType.ALL, handler);
    }

    public void http(String path, Handler handler) {
        this.add(path, MethodType.HTTP, handler);
    }

    public void head(String path, Handler handler) {
        this.add(path, MethodType.HEAD, handler);
    }

    public void get(String path, Handler handler) {
        this.add(path, MethodType.GET, handler);
    }

    public void post(String path, Handler handler) {
        this.add(path, MethodType.POST, handler);
    }

    public void put(String path, Handler handler) {
        this.add(path, MethodType.PUT, handler);
    }

    public void patch(String path, Handler handler) {
        this.add(path, MethodType.PATCH, handler);
    }

    public void delete(String path, Handler handler) {
        this.add(path, MethodType.DELETE, handler);
    }

    public void socketd(String path, Handler handler) {
        this.add(path, MethodType.SOCKET, handler);
    }
}

