/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.ActionReturnHandler;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChainImpl;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.handle.SessionStateEmpty;
import org.noear.solon.core.handle.SessionStateFactory;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.RouterInterceptorChainImpl;
import org.noear.solon.core.route.RouterInterceptorLimiter;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.lang.Nullable;

public class ChainManager {
    private final Set<Class<?>> typeSet = new HashSet();
    private final List<RankEntity<Filter>> filterNodes = new ArrayList<RankEntity<Filter>>();
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();
    private final List<RankEntity<RouterInterceptor>> interceptorNodes = new ArrayList<RankEntity<RouterInterceptor>>();
    private final Map<Class<?>, ActionReturnHandler> returnHandlers = new LinkedHashMap();
    private ActionExecuteHandler executeHandlerDefault;
    private List<RankEntity<ActionExecuteHandler>> executeHandlers = new ArrayList<RankEntity<ActionExecuteHandler>>();
    private SessionStateFactory _sessionStateFactory = ctx -> new SessionStateEmpty();
    private boolean _sessionStateUpdated;

    public Collection<Filter> getFilterNodes() {
        ArrayList<Filter> tmp = new ArrayList<Filter>();
        for (RankEntity<Filter> entity : this.filterNodes) {
            tmp.add((Filter)entity.target);
        }
        return tmp;
    }

    public void addFilter(Filter filter, int index) {
        this.SYNC_LOCK.lock();
        try {
            this.typeSet.add(filter.getClass());
            this.filterNodes.add(new RankEntity<Filter>(filter, index));
            this.filterNodes.sort(Comparator.comparingInt(f -> f.index));
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void addFilterIfAbsent(Filter filter, int index) {
        this.SYNC_LOCK.lock();
        try {
            if (this.typeSet.contains(filter.getClass())) {
                return;
            }
            this.typeSet.add(filter.getClass());
            this.filterNodes.add(new RankEntity<Filter>(filter, index));
            this.filterNodes.sort(Comparator.comparingInt(f -> f.index));
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void doFilter(Context x, Handler lastHandler) throws Throwable {
        new FilterChainImpl(this.filterNodes, lastHandler).doFilter(x);
    }

    public Collection<RouterInterceptor> getInterceptorNodes() {
        ArrayList<RouterInterceptor> tmp = new ArrayList<RouterInterceptor>();
        for (RankEntity<RouterInterceptor> entity : this.interceptorNodes) {
            if (entity.target instanceof RouterInterceptorLimiter) {
                tmp.add(((RouterInterceptorLimiter)entity.target).getInterceptor());
                continue;
            }
            tmp.add((RouterInterceptor)entity.target);
        }
        return tmp;
    }

    public void addInterceptor(RouterInterceptor interceptor, int index) {
        this.SYNC_LOCK.lock();
        try {
            this.typeSet.add(interceptor.getClass());
            interceptor = new RouterInterceptorLimiter(interceptor, interceptor.pathPatterns());
            this.interceptorNodes.add(new RankEntity<RouterInterceptor>(interceptor, index));
            this.interceptorNodes.sort(Comparator.comparingInt(f -> f.index));
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void addInterceptorIfAbsent(RouterInterceptor interceptor, int index) {
        this.SYNC_LOCK.lock();
        try {
            if (this.typeSet.contains(interceptor.getClass())) {
                return;
            }
            this.typeSet.add(interceptor.getClass());
            interceptor = new RouterInterceptorLimiter(interceptor, interceptor.pathPatterns());
            this.interceptorNodes.add(new RankEntity<RouterInterceptor>(interceptor, index));
            this.interceptorNodes.sort(Comparator.comparingInt(f -> f.index));
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public <T extends RouterInterceptor> void removeInterceptor(Class<T> clz) {
        this.SYNC_LOCK.lock();
        try {
            this.typeSet.add(clz);
            this.interceptorNodes.removeIf(i -> {
                if (i.target instanceof RouterInterceptorLimiter) {
                    return ((RouterInterceptorLimiter)i.target).getInterceptor().getClass() == clz;
                }
                return ((RouterInterceptor)i.target).getClass() == clz;
            });
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void doIntercept(Context x, Handler mainHandler, Handler lastHandler) throws Throwable {
        new RouterInterceptorChainImpl(this.interceptorNodes, lastHandler).doIntercept(x, mainHandler);
    }

    public void postArguments(Context x, ParamWrap[] args, Object[] vals) throws Throwable {
        for (int i = this.interceptorNodes.size() - 1; i >= 0; --i) {
            RankEntity<RouterInterceptor> e = this.interceptorNodes.get(i);
            ((RouterInterceptor)e.target).postArguments(x, args, vals);
        }
    }

    public Object postResult(Context x, @Nullable Object result) throws Throwable {
        for (int i = this.interceptorNodes.size() - 1; i >= 0; --i) {
            RankEntity<RouterInterceptor> e = this.interceptorNodes.get(i);
            result = ((RouterInterceptor)e.target).postResult(x, result);
        }
        return result;
    }

    public void addReturnHandler(ActionReturnHandler e) {
        if (e != null) {
            this.returnHandlers.put(e.getClass(), e);
        }
    }

    public ActionReturnHandler getReturnHandler(Context ctx, Class<?> returnType) {
        for (ActionReturnHandler handler : this.returnHandlers.values()) {
            if (!handler.matched(ctx, returnType)) continue;
            return handler;
        }
        return null;
    }

    public void defExecuteHandler(ActionExecuteHandler e) {
        if (e != null) {
            this.executeHandlerDefault = e;
        }
    }

    public void addExecuteHandler(ActionExecuteHandler e) {
        this.addExecuteHandler(e, 0);
    }

    public void addExecuteHandler(ActionExecuteHandler e, int index) {
        if (e != null) {
            this.executeHandlers.add(new RankEntity<ActionExecuteHandler>(e, index));
            if (index != 0) {
                this.executeHandlers.sort(Comparator.comparingInt(f -> f.index));
            }
        }
    }

    public void removeExecuteHandler(Class<?> clz) {
        this.executeHandlers.remove(clz);
    }

    public ActionExecuteHandler getExecuteHandler(Context c, int paramSize) {
        String ct = c.contentType();
        if (paramSize > 0) {
            for (RankEntity<ActionExecuteHandler> me : this.executeHandlers) {
                if (!((ActionExecuteHandler)me.target).matched(c, ct)) continue;
                return (ActionExecuteHandler)me.target;
            }
        }
        return this.getExecuteHandlerDefault();
    }

    public ActionExecuteHandler getExecuteHandlerDefault() {
        if (this.executeHandlerDefault == null) {
            return Solon.app().factoryManager().mvcFactory().getExecuteHandlerDefault();
        }
        return this.executeHandlerDefault;
    }

    public SessionStateFactory getSessionStateFactory() {
        return this._sessionStateFactory;
    }

    public void setSessionStateFactory(SessionStateFactory ssf) {
        if (ssf != null) {
            this._sessionStateFactory = ssf;
            this._sessionStateUpdated = true;
        }
    }

    public void refreshSessionState(Context c) {
        if (this._sessionStateUpdated) {
            c.sessionState().sessionRefresh();
        }
    }

    public SessionState getSessionState(Context ctx) {
        return this._sessionStateFactory.create(ctx);
    }
}

