/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.InjectGather;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.util.GenericUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.NameUtil;
import org.noear.solon.core.util.ParameterizedTypeImpl;
import org.noear.solon.core.wrap.FieldWrapDescriptor;
import org.noear.solon.core.wrap.VarDescriptor;
import org.noear.solon.core.wrap.VarHolderOfField;
import org.noear.solon.lang.Nullable;

public class FieldWrap {
    public final Class<?> entityClz;
    public final Field field;
    public final Annotation[] annoS;
    public final Class<?> type;
    @Nullable
    public final ParameterizedType genericType;
    public final boolean readonly;
    private Method _setter;
    private Method _getter;
    private VarDescriptor descriptor;

    protected FieldWrap(Class<?> clz, Field f1, boolean isFinal) {
        this.entityClz = clz;
        this.field = f1;
        this.annoS = f1.getAnnotations();
        this.readonly = isFinal;
        Type tmp = f1.getGenericType();
        if (tmp instanceof TypeVariable) {
            Map<String, Type> gMap = GenericUtil.getGenericInfo(clz);
            Type typeH = gMap.get(tmp.getTypeName());
            if (typeH instanceof ParameterizedType) {
                this.genericType = (ParameterizedType)typeH;
                this.type = (Class)((ParameterizedType)typeH).getRawType();
            } else {
                this.genericType = null;
                this.type = (Class)typeH;
            }
        } else {
            this.type = f1.getType();
            if (tmp instanceof ParameterizedType) {
                ParameterizedType gt0 = (ParameterizedType)tmp;
                Map<String, Type> gMap = GenericUtil.getGenericInfo(clz);
                Type[] gArgs = gt0.getActualTypeArguments();
                boolean gChanged = false;
                for (int i = 0; i < gArgs.length; ++i) {
                    Type t1 = gArgs[i];
                    if (!(t1 instanceof TypeVariable)) continue;
                    gArgs[i] = gMap.get(t1.getTypeName());
                    gChanged = true;
                }
                this.genericType = gChanged ? new ParameterizedTypeImpl((Class)gt0.getRawType(), gArgs, gt0.getOwnerType()) : gt0;
            } else {
                this.genericType = null;
            }
        }
        this._setter = FieldWrap.doFindSetter(clz, f1);
        this._getter = FieldWrap.doFindGetter(clz, f1);
    }

    public VarDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new FieldWrapDescriptor(this);
        }
        return this.descriptor;
    }

    public String getName() {
        return this.field.getName();
    }

    public VarHolder holder(AppContext ctx, Object obj, InjectGather gather) {
        return new VarHolderOfField(ctx, this, obj, gather);
    }

    public Object getValue(Object tObj) throws ReflectiveOperationException {
        if (this._getter == null) {
            return this.get(tObj);
        }
        return this._getter.invoke(tObj, new Object[0]);
    }

    public Object get(Object tObj) throws IllegalAccessException {
        if (!this.field.isAccessible()) {
            this.field.setAccessible(true);
        }
        return this.field.get(tObj);
    }

    public void setValue(Object tObj, Object val) {
        this.setValue(tObj, val, false);
    }

    public void setValue(Object tObj, Object val, boolean disFun) {
        if (this.readonly) {
            return;
        }
        try {
            if (val == null) {
                return;
            }
            if (this._setter == null || disFun) {
                if (!this.field.isAccessible()) {
                    this.field.setAccessible(true);
                }
                this.field.set(tObj, val);
            } else {
                this._setter.invoke(tObj, val);
            }
        }
        catch (IllegalArgumentException ex) {
            if (val == null) {
                throw new IllegalArgumentException(this.field.getName() + "(" + this.field.getType().getSimpleName() + ") Type receive failur!", ex);
            }
            throw new IllegalArgumentException(this.field.getName() + "(" + this.field.getType().getSimpleName() + ") Type receive failure \uff1aval(" + val.getClass().getSimpleName() + ")", ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Method doFindGetter(Class<?> tCls, Field field) {
        String getterName = NameUtil.getPropGetterName(field.getName());
        try {
            Method getFun = tCls.getMethod(getterName, new Class[0]);
            if (getFun != null) {
                return getFun;
            }
        }
        catch (NoSuchMethodException getFun) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static Method doFindSetter(Class<?> tCls, Field field) {
        String setterName = NameUtil.getPropSetterName(field.getName());
        try {
            Method setFun = tCls.getMethod(setterName, field.getType());
            if (setFun != null) {
                return setFun;
            }
        }
        catch (NoSuchMethodException setFun) {
        }
        catch (SecurityException e) {
            LogUtil.global().warn("FieldWrap doFindSetter failed!", e);
        }
        return null;
    }
}

