/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.Props;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.ContextUtil;
import org.noear.solon.core.handle.DownloadedFile;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IgnoreCaseMap;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.IpUtil;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.lang.NonNull;
import org.noear.solon.lang.Nullable;

public abstract class Context {
    private Locale locale;
    private boolean handled;
    private boolean rendered;
    private String realIp;
    private boolean allowMultipart = true;
    private Boolean isFormUrlencoded;
    private Boolean isMultipart;
    Boolean isMultipartFormData;
    private String protocolAsUpper;
    private String pathNew;
    private String pathAsUpper;
    private String pathAsLower;
    private String accept;
    private String acceptNew;
    private String body;
    private String bodyNew;
    protected SessionState sessionState;
    protected Charset charset = StandardCharsets.UTF_8;
    private String contentTypeNew;
    private Map<String, Object> attrMap = null;
    private boolean _remoting;
    @Nullable
    public Object result;
    @Nullable
    public Throwable errors;

    public static Context current() {
        return ContextUtil.current();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    public boolean getHandled() {
        return this.handled;
    }

    public void setRendered(boolean rendered) {
        this.rendered = rendered;
    }

    public boolean getRendered() {
        return this.rendered;
    }

    public Object pull(Class<?> clz) {
        if (clz.isInstance(this.request())) {
            return this.request();
        }
        if (clz.isInstance(this.response())) {
            return this.response();
        }
        if (clz.isInstance(this.sessionState())) {
            return this.sessionState();
        }
        return null;
    }

    public abstract Object request();

    @Deprecated
    public String ip() {
        return this.remoteIp();
    }

    public abstract String remoteIp();

    public abstract int remotePort();

    public String realIp() {
        if (this.realIp == null) {
            this.realIp = IpUtil.global().getRealIp(this);
        }
        return this.realIp;
    }

    public boolean autoMultipart() {
        return this.allowMultipart;
    }

    public void autoMultipart(boolean auto) {
        this.allowMultipart = auto;
    }

    public boolean isFormUrlencoded() {
        if (this.isFormUrlencoded == null) {
            String temp = this.contentType();
            this.isFormUrlencoded = temp == null ? Boolean.valueOf(false) : Boolean.valueOf(temp.toLowerCase().contains("application/x-www-form-urlencoded"));
        }
        return this.isFormUrlencoded;
    }

    public boolean isMultipart() {
        if (this.isMultipart == null) {
            String temp = this.contentType();
            this.isMultipart = temp == null ? Boolean.valueOf(false) : Boolean.valueOf(temp.toLowerCase().contains("multipart/"));
        }
        return this.isMultipart;
    }

    public boolean isMultipartFormData() {
        if (this.isMultipartFormData == null) {
            String temp = this.contentType();
            this.isMultipartFormData = temp == null ? Boolean.valueOf(false) : Boolean.valueOf(temp.toLowerCase().contains("multipart/form-data"));
        }
        return this.isMultipartFormData;
    }

    public abstract String method();

    public abstract String protocol();

    public String protocolAsUpper() {
        if (this.protocolAsUpper == null) {
            this.protocolAsUpper = this.protocol().toUpperCase();
        }
        return this.protocolAsUpper;
    }

    public abstract URI uri();

    public abstract String path();

    public void pathNew(String pathNew) {
        this.pathNew = pathNew;
    }

    public String pathNew() {
        if (this.pathNew == null) {
            return this.path();
        }
        return this.pathNew;
    }

    public Map<String, String> pathMap(String expr) {
        return PathUtil.pathVarMap(this.path(), expr);
    }

    public String pathAsUpper() {
        if (this.pathAsUpper == null) {
            this.pathAsUpper = this.path().toUpperCase();
        }
        return this.pathAsUpper;
    }

    public String pathAsLower() {
        if (this.pathAsLower == null) {
            this.pathAsLower = this.path().toLowerCase();
        }
        return this.pathAsLower;
    }

    public abstract boolean isSecure();

    public String userAgent() {
        return this.header("User-Agent");
    }

    public abstract String url();

    public abstract long contentLength();

    public abstract String contentType();

    public abstract String contentCharset();

    public abstract String queryString();

    public String accept() {
        if (this.accept == null) {
            this.accept = this.headerOrDefault("Accept", "");
        }
        return this.accept;
    }

    public void accept(String acceptNew) {
        this.acceptNew = acceptNew;
    }

    public String acceptNew() {
        if (this.acceptNew == null) {
            return this.accept();
        }
        return this.acceptNew;
    }

    public String body() throws IOException {
        return this.body(this.contentCharset());
    }

    public String body(String charset) throws IOException {
        if (this.body == null) {
            try (InputStream ins = this.bodyAsStream();){
                this.body = IoUtil.transferToString(ins, charset);
            }
        }
        return this.body;
    }

    public String bodyNew() throws IOException {
        if (this.bodyNew == null) {
            return this.body();
        }
        return this.bodyNew;
    }

    public void bodyNew(String bodyNew) {
        this.bodyNew = bodyNew;
    }

    public byte[] bodyAsBytes() throws IOException {
        try (InputStream ins = this.bodyAsStream();){
            if (ins == null) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayOutputStream outs = new ByteArrayOutputStream();
            int len = 0;
            byte[] buf = new byte[512];
            while ((len = ins.read(buf)) != -1) {
                outs.write(buf, 0, len);
            }
            byte[] byArray = outs.toByteArray();
            return byArray;
        }
    }

    public abstract InputStream bodyAsStream() throws IOException;

    @Nullable
    public String[] paramValues(String name) {
        List<String> tmp = this.paramMap().getAll(name);
        return tmp == null ? null : tmp.toArray(new String[tmp.size()]);
    }

    @Nullable
    public String param(String name) {
        return this.paramMap().get(name);
    }

    @Deprecated
    public String param(String key, String def) {
        return this.paramOrDefault(key, def);
    }

    public String paramOrDefault(String key, String def) {
        return this.paramMap().getOrDefault(key, def);
    }

    public int paramAsInt(String name) {
        return this.paramAsInt(name, 0);
    }

    public int paramAsInt(String name, int def) {
        return Integer.parseInt(this.paramOrDefault(name, String.valueOf(def)));
    }

    public long paramAsLong(String name) {
        return this.paramAsLong(name, 0L);
    }

    public long paramAsLong(String name, long def) {
        return Long.parseLong(this.paramOrDefault(name, String.valueOf(def)));
    }

    public double paramAsDouble(String name) {
        return this.paramAsDouble(name, 0.0);
    }

    public double paramAsDouble(String name, double def) {
        return Double.parseDouble(this.paramOrDefault(name, String.valueOf(def)));
    }

    public BigDecimal paramAsDecimal(String name) {
        return this.paramAsDecimal(name, BigDecimal.ZERO);
    }

    public BigDecimal paramAsDecimal(String name, BigDecimal def) {
        String tmp = this.param(name);
        if (Utils.isEmpty(tmp)) {
            return def;
        }
        return new BigDecimal(tmp);
    }

    public <T> T paramAsBean(Class<T> type) {
        return PropsConverter.global().convert(new Props(this.paramMap()), type);
    }

    public Set<String> paramNames() {
        return this.paramMap().keySet();
    }

    public abstract MultiMap<String> paramMap();

    @Deprecated
    public void paramSet(String name, String value) {
        this.paramMap().add(name, value);
    }

    @Deprecated
    public Map<String, List<String>> paramsMap() {
        return this.paramMap().toValuesMap();
    }

    @Deprecated
    public List<UploadedFile> files(String name) throws IOException {
        return this.fileMap().getAll(name);
    }

    @Nullable
    public UploadedFile[] fileValues(String name) {
        List<UploadedFile> tmp = this.fileMap().getAll(name);
        return tmp == null ? null : tmp.toArray(new UploadedFile[tmp.size()]);
    }

    @Nullable
    public UploadedFile file(String name) throws IOException {
        return this.fileMap().get(name);
    }

    public abstract void filesDelete() throws IOException;

    public Set<String> fileNames() {
        return this.fileMap().keySet();
    }

    public abstract MultiMap<UploadedFile> fileMap();

    @Deprecated
    public Map<String, List<UploadedFile>> filesMap() {
        return this.fileMap().toValuesMap();
    }

    @Nullable
    public String cookie(String name) {
        return this.cookieMap().get(name);
    }

    @Deprecated
    public String cookie(String name, String def) {
        return this.cookieOrDefault(name, def);
    }

    public String cookieOrDefault(String name, String def) {
        return this.cookieMap().getOrDefault(name, def);
    }

    @Nullable
    public String[] cookieValues(String name) {
        List<String> tmp = this.cookieMap().getAll(name);
        return tmp == null ? null : tmp.toArray(new String[tmp.size()]);
    }

    public Set<String> cookieNames() {
        return this.cookieMap().keySet();
    }

    public abstract MultiMap<String> cookieMap();

    @Nullable
    public String header(String name) {
        return this.headerMap().get(name);
    }

    @Deprecated
    public String header(String name, String def) {
        return this.headerOrDefault(name, def);
    }

    public String headerOrDefault(String name, String def) {
        return this.headerMap().getOrDefault(name, def);
    }

    @Nullable
    public String[] headerValues(String name) {
        List<String> tmp = this.headerMap().getAll(name);
        return tmp == null ? null : tmp.toArray(new String[tmp.size()]);
    }

    public Set<String> headerNames() {
        return this.headerMap().keySet();
    }

    public abstract MultiMap<String> headerMap();

    @Deprecated
    public Map<String, List<String>> headersMap() {
        return this.headerMap().toValuesMap();
    }

    public SessionState sessionState() {
        if (this.sessionState == null) {
            this.sessionState = Solon.app().chainManager().getSessionState(this);
        }
        return this.sessionState;
    }

    public abstract String sessionId();

    public final Object session(String name) {
        return this.session(name, (Object)Object.class);
    }

    public abstract <T> T session(String var1, Class<T> var2);

    @Deprecated
    @Nullable
    public <T> T session(String name, @NonNull T def) {
        return this.sessionOrDefault(name, def);
    }

    public abstract <T> T sessionOrDefault(String var1, @NonNull T var2);

    public abstract int sessionAsInt(String var1);

    public abstract int sessionAsInt(String var1, int var2);

    public abstract long sessionAsLong(String var1);

    public abstract long sessionAsLong(String var1, long var2);

    public abstract double sessionAsDouble(String var1);

    public abstract double sessionAsDouble(String var1, double var2);

    public abstract void sessionSet(String var1, Object var2);

    public abstract void sessionRemove(String var1);

    public abstract void sessionClear();

    public abstract void sessionReset();

    public abstract Object response();

    public void charset(String charset) {
        this.charset = Charset.forName(charset);
    }

    public void contentType(String contentType) {
        this.contentTypeDoSet(contentType);
        if (!"text/plain;charset=UTF-8".equals(contentType)) {
            this.contentTypeNew = contentType;
        }
    }

    public String contentTypeNew() {
        return this.contentTypeNew;
    }

    protected abstract void contentTypeDoSet(String var1);

    public void contentLength(long size) {
        if (size >= 0L) {
            this.headerSet("Content-Length", String.valueOf(size));
        }
    }

    public abstract void output(byte[] var1);

    public abstract void output(InputStream var1);

    public abstract OutputStream outputStream() throws IOException;

    public abstract GZIPOutputStream outputStreamAsGzip() throws IOException;

    public void output(String str) {
        if (str != null) {
            this.attrSet("output", str);
            this.output(str.getBytes(this.charset));
        }
    }

    public void output(Throwable ex) {
        this.output(Utils.getFullStackTrace(ex));
    }

    public void outputAsJson(String json) {
        this.contentType("application/json;charset=utf-8");
        this.output(json);
    }

    public void outputAsHtml(String html) {
        this.contentType("text/html;charset=utf-8");
        if (!html.startsWith("<")) {
            StringBuilder sb = new StringBuilder();
            sb.append("<!doctype html>");
            sb.append("<html>");
            sb.append(html);
            sb.append("</html>");
            this.output(sb.toString());
        } else {
            this.output(html);
        }
    }

    public abstract void outputAsFile(DownloadedFile var1) throws IOException;

    public abstract void outputAsFile(File var1) throws IOException;

    public abstract void headerSet(String var1, String var2);

    public abstract void headerAdd(String var1, String var2);

    public abstract String headerOfResponse(String var1);

    public abstract Collection<String> headerValuesOfResponse(String var1);

    public abstract Collection<String> headerNamesOfResponse();

    public void cookieSet(String name, String val) {
        this.cookieSet(name, val, null, -1);
    }

    public void cookieSet(String name, String val, int maxAge) {
        this.cookieSet(name, val, null, maxAge);
    }

    public void cookieSet(String name, String val, String domain, int maxAge) {
        this.cookieSet(name, val, domain, "/", maxAge);
    }

    public abstract void cookieSet(String var1, String var2, String var3, String var4, int var5);

    public void cookieRemove(String name) {
        this.cookieSet(name, "", 0);
    }

    public void redirect(String url) {
        this.redirect(url, 302);
    }

    public abstract void redirect(String var1, int var2);

    public void forward(String pathNew) {
        if (Utils.isEmpty(Solon.cfg().serverContextPath())) {
            this.pathNew(pathNew);
        } else {
            this.pathNew(PathUtil.mergePath(Solon.cfg().serverContextPath(), pathNew));
        }
        Solon.app().tryHandle(this);
        this.setHandled(true);
        this.setRendered(true);
    }

    public abstract int status();

    public void status(int status) {
        this.statusDoSet(status);
    }

    @Deprecated
    public void statusSet(int status) {
        this.statusDoSet(status);
    }

    protected abstract void statusDoSet(int var1);

    public Map<String, Object> attrMap() {
        if (this.attrMap == null) {
            this.attrMap = new IgnoreCaseMap<Object>();
        }
        return this.attrMap;
    }

    public <T> T attrOrDefault(String name, T def) {
        Object val = this.attrMap().get(name);
        if (val == null) {
            return def;
        }
        return (T)val;
    }

    @Deprecated
    public <T> T attr(String name, T def) {
        return this.attrOrDefault(name, def);
    }

    @Nullable
    public <T> T attr(String name) {
        return (T)this.attrMap().get(name);
    }

    public void attrSet(String name, Object val) {
        this.attrMap().put(name, val);
    }

    public void attrSet(Map<String, Object> map) {
        this.attrMap().putAll(map);
    }

    @Deprecated
    public void attrClear() {
        this.attrsClear();
    }

    public void attrsClear() {
        this.attrMap().clear();
    }

    public final void render(Object obj) throws Throwable {
        this.setRendered(true);
        RenderManager.global.render(obj, this);
    }

    public final void render(String view, Map<String, ?> data) throws Throwable {
        this.render(new ModelAndView(view, data));
    }

    public final String renderAndReturn(Object obj) throws Throwable {
        return RenderManager.global.renderAndReturn(obj, this);
    }

    public boolean remoting() {
        return this._remoting;
    }

    public void remotingSet(boolean remoting) {
        this._remoting = remoting;
    }

    public abstract void flush() throws IOException;

    public abstract void close() throws IOException;

    public abstract boolean asyncSupported();

    public abstract void asyncStart(long var1, ContextAsyncListener var3, Runnable var4);

    public void asyncStart() {
        this.asyncStart(0L, null, null);
    }

    public abstract void asyncComplete();

    @Nullable
    public Object controller() {
        return this.attr("controller");
    }

    @Nullable
    public Action action() {
        return (Action)this.attr("action");
    }

    @Nullable
    public Handler mainHandler() {
        return (Handler)this.attr("mainHandler");
    }
}

