/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.Properties;
import org.noear.solon.Utils;

public class PropUtil {
    public static String[] expSplit(String expr) {
        if (expr.startsWith("${") && expr.endsWith("}")) {
            expr = expr.substring(2, expr.length() - 1);
        }
        String def = null;
        int defIdx = expr.indexOf(58);
        if (defIdx > 0) {
            def = expr.length() > defIdx + 1 ? expr.substring(defIdx + 1).trim() : "";
            expr = expr.substring(0, defIdx).trim();
        }
        return new String[]{expr, def};
    }

    public static String getByExp(Properties main, Properties target, String expr) {
        return PropUtil.getByExp(main, target, expr, true);
    }

    public static String getByExp(Properties main, Properties target, String expr, boolean useDef) {
        String[] nameAndDef = PropUtil.expSplit(expr);
        String name = nameAndDef[0];
        if (Utils.isEmpty(name)) {
            return nameAndDef[1];
        }
        String val = null;
        if (target != null) {
            val = target.getProperty(name);
        }
        if (val == null && (val = main.getProperty(name)) == null && (Character.isUpperCase(name.charAt(0)) || name.charAt(0) == '_') && (val = System.getenv(name)) == null) {
            return nameAndDef[1];
        }
        if (val == null) {
            if (useDef) {
                return nameAndDef[1];
            }
            return null;
        }
        return val;
    }

    public static String getByTml(Properties main, Properties target, String tml) {
        return PropUtil.getByTml(main, target, tml, true);
    }

    public static String getByTml(Properties main, Properties target, String tml, boolean useDef) {
        if (Utils.isEmpty(tml)) {
            return tml;
        }
        int start = 0;
        int end = 0;
        while ((start = tml.indexOf("${")) >= 0) {
            end = tml.indexOf(125, start);
            if (end < 0) {
                throw new IllegalStateException("Invalid template expression: " + tml);
            }
            String valueExp = tml.substring(start + 2, end);
            String value = PropUtil.getByExp(main, target, valueExp, useDef);
            if (value == null) {
                return null;
            }
            tml = tml.substring(0, start) + value + tml.substring(end + 1);
        }
        return tml;
    }
}

