/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.noear.solon.annotation.Singleton;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrapLifecycle;
import org.noear.solon.core.util.ClassUtil;

public class BeanWrap {
    private Class<?> clz;
    private BeanWrapLifecycle lifecycle;
    private Object raw;
    private Object rawUnproxied;
    private Class<?> rawClz;
    private boolean singleton;
    private boolean remoting;
    private String name;
    private int index;
    private String tag;
    private boolean typed;
    private Proxy proxy;
    private final Annotation[] annotations;
    private final AppContext context;

    public BeanWrap(AppContext context, Class<?> clz) {
        this(context, clz, null);
    }

    public BeanWrap(AppContext context, Class<?> clz, Object raw) {
        this(context, clz, raw, null);
    }

    public BeanWrap(AppContext context, Class<?> clz, Object raw, String name) {
        this(context, clz, raw, name, false, null, null);
    }

    public BeanWrap(AppContext context, Class<?> clz, Object raw, String name, boolean typed, String initMethodName, String destroyMethodName) {
        this.context = context;
        this.clz = clz;
        this.name = name;
        this.typed = typed;
        Singleton anoS = clz.getAnnotation(Singleton.class);
        this.singleton = anoS == null || anoS.value();
        this.annotations = clz.getAnnotations();
        this.raw = raw == null ? (this.rawUnproxied = this._new()) : (this.rawUnproxied = raw);
        if (this.rawUnproxied != null) {
            this.rawClz = this.rawUnproxied.getClass();
            if (this.rawClz.isAnonymousClass()) {
                this.rawClz = this.rawClz.getSuperclass();
            }
        }
        this.tryInit(initMethodName, destroyMethodName);
    }

    public AppContext context() {
        return this.context;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public void proxySet(Proxy proxy) {
        this.proxy = proxy;
        if (this.raw != null) {
            this.raw = proxy.getProxy(this.context(), this.raw);
        }
    }

    public boolean singleton() {
        return this.singleton;
    }

    public void singletonSet(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean remoting() {
        return this.remoting;
    }

    public void remotingSet(boolean remoting) {
        this.remoting = remoting;
    }

    public Class<?> clz() {
        return this.clz;
    }

    public Method clzInit() {
        return this.lifecycle.initMethod();
    }

    public Method clzDestroy() {
        return this.lifecycle.destroyMethod();
    }

    public <T> T raw(boolean unproxied) {
        if (unproxied) {
            return (T)this.rawUnproxied;
        }
        return (T)this.raw;
    }

    public <T> T raw() {
        return this.raw(false);
    }

    public void rawSet(Object raw) {
        if (this.raw == null) {
            this.raw = raw;
        }
    }

    public Class<?> rawClz() {
        if (this.rawClz == null) {
            return this.clz;
        }
        return this.rawClz;
    }

    public String name() {
        return this.name;
    }

    protected void nameSet(String name) {
        this.name = name;
    }

    public int index() {
        return this.index;
    }

    protected void indexSet(int index) {
        this.index = index;
    }

    public String tag() {
        return this.tag;
    }

    protected void tagSet(String tag) {
        if (this.tag == null) {
            this.tag = tag;
        }
    }

    public boolean typed() {
        return this.typed;
    }

    protected void typedSet(boolean typed) {
        this.typed = typed;
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    public <T extends Annotation> T annotationGet(Class<T> annClz) {
        return this.clz.getAnnotation(annClz);
    }

    public <T> T get() {
        return this.get(false);
    }

    public <T> T get(boolean unproxied) {
        if (unproxied) {
            if (this.singleton) {
                return (T)this.rawUnproxied;
            }
            return (T)this._new();
        }
        if (this.singleton) {
            return (T)this.raw;
        }
        Object tmp = this._new();
        if (this.proxy != null) {
            tmp = this.proxy.getProxy(this.context(), tmp);
        }
        return (T)tmp;
    }

    public <T> T create() {
        Object tmp = this._new();
        if (this.proxy != null) {
            tmp = this.proxy.getProxy(this.context(), tmp);
        }
        return (T)tmp;
    }

    protected Object _new() {
        if (this.clz.isInterface()) {
            return this.raw;
        }
        try {
            Object bean = ClassUtil.newInstance(this.clz);
            this.context.beanInject(bean);
            return bean;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Instantiation failure: " + this.clz.getTypeName(), ex);
        }
    }

    protected void tryInit(String initMethodName, String destroyMethodName) {
        if (this.lifecycle == null) {
            this.lifecycle = new BeanWrapLifecycle(this, initMethodName, destroyMethodName);
            if (this.lifecycle.check()) {
                this.context.lifecycle(this.lifecycle.index() + 1, this.lifecycle);
            }
        }
    }

    @FunctionalInterface
    public static interface Proxy {
        public Object getProxy(AppContext var1, Object var2);
    }
}

