/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Properties;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.exception.ConstructionException;
import org.noear.solon.core.util.SupplierEx;

public class ClassUtil {
    private static final ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();

    public static boolean hasClass(SupplierEx<Class<?>> test) {
        try {
            test.get();
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static Class<?> loadClass(String className) {
        return ClassUtil.loadClass(null, className);
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            if (classLoader == null) {
                return Class.forName(className);
            }
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    public static <T> T tryInstance(String className) {
        return ClassUtil.tryInstance(className, null);
    }

    public static <T> T tryInstance(String className, Properties prop) {
        return ClassUtil.tryInstance(AppClassLoader.global(), className, prop);
    }

    public static <T> T tryInstance(ClassLoader classLoader, String className) {
        return ClassUtil.tryInstance(classLoader, className, null);
    }

    public static <T> T tryInstance(ClassLoader classLoader, String className, Properties prop) {
        Class<?> clz = ClassUtil.loadClass(classLoader, className);
        return ClassUtil.tryInstance(clz, prop);
    }

    public static <T> T tryInstance(Class<?> clz, Properties prop) {
        if (clz == null) {
            return null;
        }
        try {
            return ClassUtil.newInstance(clz, prop);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T newInstance(Class<?> clz) throws ConstructionException {
        return ClassUtil.newInstance(clz, null);
    }

    public static <T> T newInstance(Class<?> clz, Properties prop) throws ConstructionException {
        try {
            if (prop == null) {
                return (T)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (T)clz.getConstructor(Properties.class).newInstance(prop);
        }
        catch (Exception e) {
            throw new ConstructionException(e);
        }
    }

    @Deprecated
    public static <T> T newInstance(String className) {
        return ClassUtil.tryInstance(className);
    }

    @Deprecated
    public static <T> T newInstance(String className, Properties prop) {
        return ClassUtil.tryInstance(className, prop);
    }

    @Deprecated
    public static <T> T newInstance(ClassLoader classLoader, String className) {
        return ClassUtil.tryInstance(classLoader, className);
    }

    @Deprecated
    public static <T> T newInstance(ClassLoader classLoader, String className, Properties prop) {
        return ClassUtil.tryInstance(classLoader, className, prop);
    }

    public static ClassLoader resolveClassLoader(Type type) {
        ClassLoader cl;
        Class<?> clz;
        ClassLoader loader = AppClassLoader.global();
        if (type != null && (clz = ClassUtil.getTypeClass(type)) != Object.class && (cl = clz.getClassLoader()) != systemClassLoader) {
            loader = cl;
        }
        return loader;
    }

    public static Class<?> getTypeClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtil.getTypeClass(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }
}

