/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.noear.solon.core.util.IoUtil;

public abstract class FileBase {
    protected InputStream content;
    protected String contentType;
    protected long contentSize;
    protected String name;

    public InputStream getContent() throws IOException {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getContentSize() throws IOException {
        if (this.contentSize > 0L) {
            return this.contentSize;
        }
        return this.getContent().available();
    }

    public String getName() {
        return this.name;
    }

    public FileBase() {
    }

    public FileBase(String contentType, long contentSize, InputStream content, String name) {
        this.contentType = contentType;
        this.contentSize = contentSize;
        this.content = content;
        this.name = name;
    }

    public void transferTo(File file) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(file);){
            IoUtil.transferTo(this.getContent(), stream);
        }
    }

    public void transferTo(OutputStream stream) throws IOException {
        IoUtil.transferTo(this.getContent(), stream);
    }
}

