/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.net.URL;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.noear.solon.Utils;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.ScanUtil;

public class PluginUtil {
    @Deprecated
    public static void scanPlugins(ClassLoader classLoader, String limitFile, Consumer<PluginEntity> consumer) {
        PluginUtil.scanPlugins(classLoader, consumer);
    }

    public static void scanPlugins(ClassLoader classLoader, Consumer<PluginEntity> consumer) {
        Set<String> nameList = ScanUtil.scan(classLoader, "META-INF/solon", n -> n.endsWith(".properties"));
        for (String name : nameList) {
            URL res = ResourceUtil.getResource(classLoader, name);
            if (res == null) {
                LogUtil.global().warn("Solon plugin: name=" + name + ", resource is null");
                continue;
            }
            Properties props = Utils.loadProperties(res);
            PluginUtil.findPlugins(classLoader, props, consumer);
        }
    }

    public static void findPlugins(ClassLoader classLoader, Properties props, Consumer<PluginEntity> consumer) {
        String pluginStr = props.getProperty("solon.plugin");
        if (Utils.isNotEmpty(pluginStr)) {
            String[] plugins;
            String priorityStr = props.getProperty("solon.plugin.priority");
            int priority = 0;
            if (Utils.isNotEmpty(priorityStr)) {
                priority = Integer.parseInt(priorityStr);
            }
            for (String clzName : plugins = pluginStr.trim().split(",")) {
                if (clzName.length() <= 0) continue;
                PluginEntity ent = new PluginEntity(classLoader, clzName.trim(), props);
                ent.setPriority(priority);
                consumer.accept(ent);
            }
        }
    }
}

