/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.Collection;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Endpoint;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.MethodTypeUtil;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.route.Router;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.route.RoutingDefault;
import org.noear.solon.core.route.RoutingTable;
import org.noear.solon.core.route.RoutingTableDefault;
import org.noear.solon.core.util.PathAnalyzer;

public class RouterDefault
implements Router {
    private final RoutingTable<Handler>[] routesH = new RoutingTableDefault[3];

    public RouterDefault() {
        this.routesH[0] = new RoutingTableDefault<Handler>();
        this.routesH[1] = new RoutingTableDefault<Handler>();
        this.routesH[2] = new RoutingTableDefault<Handler>();
    }

    @Override
    public void caseSensitive(boolean caseSensitive) {
        PathAnalyzer.setCaseSensitive(caseSensitive);
    }

    @Override
    public void add(String path, Endpoint endpoint, MethodType method, int index, Handler handler) {
        RoutingDefault<Handler> routing = new RoutingDefault<Handler>(path, method, index, handler);
        if (path.contains("*") || path.contains("{")) {
            this.routesH[endpoint.code].add(routing);
        } else {
            this.routesH[endpoint.code].add(0, routing);
        }
    }

    @Override
    @Deprecated
    public Handler matchOne(Context ctx, Endpoint endpoint) {
        String pathNew = ctx.pathNew();
        MethodType method = MethodTypeUtil.valueOf(ctx.method());
        return this.routesH[endpoint.code].matchOne(pathNew, method);
    }

    @Override
    public Handler matchMain(Context ctx) {
        MethodType method;
        String pathNew = ctx.pathNew();
        Result<Handler> result = this.routesH[Endpoint.main.code].matchOneAndStatus(pathNew, method = MethodTypeUtil.valueOf(ctx.method()));
        if (result.getData() != null) {
            ctx.attrSet("mainHandler", result.getData());
        } else {
            ctx.attrSet("mainStatus", result.getCode());
        }
        return result.getData();
    }

    @Override
    public List<Handler> matchMore(Context ctx, Endpoint endpoint) {
        String pathNew = ctx.pathNew();
        MethodType method = MethodTypeUtil.valueOf(ctx.method());
        return this.routesH[endpoint.code].matchMore(pathNew, method);
    }

    @Override
    public Collection<Routing<Handler>> getAll(Endpoint endpoint) {
        return this.routesH[endpoint.code].getAll();
    }

    @Override
    public Collection<Routing<Handler>> getBy(String path, Endpoint endpoint) {
        return this.routesH[endpoint.code].getBy(path);
    }

    @Override
    public void remove(String pathPrefix) {
        this.routesH[Endpoint.before.code].remove(pathPrefix);
        this.routesH[Endpoint.main.code].remove(pathPrefix);
        this.routesH[Endpoint.after.code].remove(pathPrefix);
    }

    @Override
    public void clear() {
        this.routesH[0].clear();
        this.routesH[1].clear();
        this.routesH[2].clear();
    }
}

