/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.FieldWrap;

public class TmlUtil {
    public static String parse(String tml, Invocation inv) {
        if (tml.indexOf("$") < 0) {
            return tml;
        }
        return TmlUtil.parse(tml, inv.argsAsMap(), null);
    }

    public static String parse(String tml, Invocation inv, Object rst) {
        if (tml.indexOf("$") < 0) {
            return tml;
        }
        return TmlUtil.parse(tml, inv.argsAsMap(), rst);
    }

    public static String parse(String tml, Map<String, Object> params) {
        return TmlUtil.parse(tml, params, null);
    }

    public static String parse(String tml, Map<String, Object> params, Object result) {
        if (tml.indexOf("$") < 0) {
            return tml;
        }
        String str2 = tml;
        Pattern pattern = Pattern.compile("\\$\\{(\\w*\\.?\\w+)\\}");
        Matcher m = pattern.matcher(tml);
        while (m.find()) {
            String mark = m.group(0);
            String name = m.group(1);
            if (params.containsKey(name)) {
                String val = String.valueOf(params.get(name));
                str2 = str2.replace(mark, val);
                continue;
            }
            if (name.contains(".")) {
                Object obj;
                String fieldKey = null;
                String fieldVal = null;
                if (name.startsWith(".")) {
                    obj = result;
                    fieldKey = name.substring(1);
                } else {
                    String[] cf = name.split("\\.");
                    obj = params.get(cf[0]);
                    fieldKey = cf[1];
                }
                if (obj != null) {
                    Object valTmp = null;
                    if (obj instanceof Map) {
                        valTmp = ((Map)obj).get(fieldKey);
                    } else {
                        FieldWrap fw = ClassWrap.get(obj.getClass()).getFieldWrap(fieldKey);
                        if (fw == null) {
                            throw new IllegalArgumentException("Missing cache tag parameter (result field): " + name);
                        }
                        try {
                            valTmp = fw.getValue(obj);
                        }
                        catch (ReflectiveOperationException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (valTmp != null) {
                        fieldVal = valTmp.toString();
                    }
                }
                if (fieldVal == null) {
                    fieldVal = "";
                }
                str2 = str2.replace(mark, fieldVal);
                continue;
            }
            throw new IllegalArgumentException("Missing tml parameter: " + name);
        }
        return str2;
    }
}

