/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.ScanUtil;

public class ResourceUtil {
    public static final String TAG_classpath = "classpath:";
    public static final String TAG_classpath_ = "classpath*:";

    public static boolean hasClasspath(String path) {
        return path.startsWith(TAG_classpath) || path.startsWith(TAG_classpath_);
    }

    public static String remClasspath(String path) {
        int idx = path.indexOf(58);
        if (idx == 9 || idx == 10) {
            return path.substring(idx + 1);
        }
        return path;
    }

    public static Enumeration<URL> getResources(String name) throws IOException {
        return ResourceUtil.getResources(null, name);
    }

    public static Enumeration<URL> getResources(ClassLoader classLoader, String name) throws IOException {
        if (classLoader == null) {
            return AppClassLoader.global().getResources(name);
        }
        return classLoader.getResources(name);
    }

    public static boolean hasResource(String name) {
        return ResourceUtil.getResource(name) != null;
    }

    public static boolean hasResource(ClassLoader classLoader, String name) {
        return ResourceUtil.getResource(classLoader, name) != null;
    }

    public static URL getResource(String name) {
        return ResourceUtil.getResource(null, name);
    }

    public static URL getResource(ClassLoader classLoader, String name) {
        if (classLoader == null) {
            return AppClassLoader.global().getResource(name);
        }
        return classLoader.getResource(name);
    }

    public static String getResourceAsString(String name) throws IOException {
        return ResourceUtil.getResourceAsString(AppClassLoader.global(), name, Solon.encoding());
    }

    public static String getResourceAsString(String name, String charset) throws IOException {
        return ResourceUtil.getResourceAsString(AppClassLoader.global(), name, charset);
    }

    public static String getResourceAsString(ClassLoader classLoader, String name, String charset) throws IOException {
        URL url = ResourceUtil.getResource(classLoader, name);
        if (url != null) {
            try (InputStream in = url.openStream();){
                String string = IoUtil.transferToString(in, charset);
                return string;
            }
        }
        return null;
    }

    public static InputStream getResourceAsStream(String name) throws IOException {
        return ResourceUtil.getResourceAsStream(AppClassLoader.global(), name);
    }

    public static InputStream getResourceAsStream(ClassLoader classLoader, String name) throws IOException {
        URL url = ResourceUtil.getResource(classLoader, name);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public static String findResourceAsString(String uri) throws IOException {
        URL url = ResourceUtil.findResource(uri);
        if (url != null) {
            try (InputStream in = url.openStream();){
                String string = IoUtil.transferToString(in, Solon.encoding());
                return string;
            }
        }
        return null;
    }

    public static URL findResource(String uri) {
        return ResourceUtil.findResource(null, uri);
    }

    public static URL findResource(ClassLoader classLoader, String uri) {
        if (ResourceUtil.hasClasspath(uri)) {
            return ResourceUtil.getResource(classLoader, ResourceUtil.remClasspath(uri));
        }
        try {
            File file = Utils.getFile(uri);
            if (!file.exists()) {
                return null;
            }
            return file.toURI().toURL();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Collection<Class<?>> scanClasses(String clzExpr) {
        return ResourceUtil.scanClasses(AppClassLoader.global(), clzExpr);
    }

    public static Collection<Class<?>> scanClasses(ClassLoader classLoader, String clzExpr) {
        int idx;
        ArrayList clzList = new ArrayList();
        if (clzExpr.indexOf(42) < 0) {
            if (clzExpr.endsWith(".class")) {
                Class<?> clz = ClassUtil.loadClass(classLoader, clzExpr = clzExpr.substring(0, clzExpr.length() - 6));
                if (clz != null) {
                    clzList.add(clz);
                }
                return clzList;
            }
            idx = clzExpr.lastIndexOf(46);
            if (idx > 0 && Character.isLowerCase(clzExpr.charAt(idx + 1))) {
                clzExpr = clzExpr + ".*";
            } else {
                Class<?> clz = ClassUtil.loadClass(classLoader, clzExpr);
                if (clz != null) {
                    clzList.add(clz);
                }
                return clzList;
            }
        }
        if (clzExpr.endsWith(".class")) {
            clzExpr = clzExpr.substring(0, clzExpr.length() - 6);
        } else {
            idx = clzExpr.lastIndexOf(46);
            if (idx > 0 && clzExpr.indexOf(42, idx) < 0 && Character.isLowerCase(clzExpr.charAt(idx + 1))) {
                clzExpr = clzExpr + ".*";
            }
        }
        clzExpr = clzExpr.replace('.', '/');
        clzExpr = clzExpr + ".class";
        ResourceUtil.scanResources(classLoader, clzExpr).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class<?> clz = ClassUtil.loadClass(classLoader, className = className.replace('/', '.'));
            if (clz != null) {
                clzList.add(clz);
            }
        });
        return clzList;
    }

    public static Collection<String> scanResources(String resExpr) {
        return ResourceUtil.scanResources(AppClassLoader.global(), resExpr);
    }

    public static Collection<String> scanResources(ClassLoader classLoader, String resExpr) {
        int xinIdx;
        ArrayList<String> paths = new ArrayList<String>();
        if (ResourceUtil.hasClasspath(resExpr)) {
            resExpr = ResourceUtil.remClasspath(resExpr);
        }
        if (resExpr.startsWith("/")) {
            resExpr = resExpr.substring(1);
        }
        if ((xinIdx = resExpr.indexOf(42)) < 0) {
            paths.add(resExpr);
            return paths;
        }
        int dirIdx = resExpr.indexOf("/");
        if (dirIdx < 1 || dirIdx > xinIdx) {
            throw new IllegalArgumentException("Expressions without a first-level directory are not supported: " + resExpr);
        }
        String dir = resExpr.substring(0, dirIdx);
        int sufIdx = resExpr.lastIndexOf(46);
        String suf = null;
        if (sufIdx > 0 && (suf = resExpr.substring(sufIdx)).indexOf(42) >= 0) {
            sufIdx = -1;
            suf = null;
        }
        int sufIdx2 = sufIdx;
        String suf2 = suf;
        String expr = resExpr;
        expr = expr.replace("/**", "(/[^/]#)#");
        expr = expr.replace("*", "[^/]+");
        expr = expr.replace('#', '*');
        Pattern pattern = Pattern.compile(expr);
        ScanUtil.scan(classLoader, dir, n -> {
            if (sufIdx2 > 0) {
                return n.endsWith(suf2);
            }
            return true;
        }).forEach(uri -> {
            if (pattern.matcher((CharSequence)uri).find()) {
                paths.add((String)uri);
            }
        });
        return paths;
    }
}

