/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ChainManager;
import org.noear.solon.core.handle.Endpoint;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerSlots;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.route.Router;
import org.noear.solon.core.route.RouterDefault;
import org.noear.solon.core.route.RouterHandler;
import org.noear.solon.core.route.RouterInterceptor;

public abstract class RouterWrapper
implements HandlerSlots {
    private Router _router;
    private RouterHandler _routerHandler;
    private ChainManager _chainManager;

    public abstract AppContext context();

    protected void initRouter(Filter appFilter) {
        this._chainManager = new ChainManager();
        this._router = new RouterDefault();
        this._routerHandler = new RouterHandler(this._router);
        this._chainManager.addInterceptor(this._routerHandler, Integer.MAX_VALUE);
        this._chainManager.addFilter(appFilter, Integer.MAX_VALUE);
    }

    protected RouterHandler routerHandler() {
        return this._routerHandler;
    }

    public Router router() {
        return this._router;
    }

    public ChainManager chainManager() {
        return this._chainManager;
    }

    public void filter(Filter filter) {
        this.filter(0, filter);
    }

    public void filter(int index, Filter filter) {
        this._chainManager.addFilter(filter, index);
    }

    public void filterIfAbsent(int index, Filter filter) {
        this._chainManager.addFilterIfAbsent(filter, index);
    }

    public void routerInterceptor(RouterInterceptor interceptor) {
        this._chainManager.addInterceptor(interceptor, 0);
    }

    public void routerInterceptor(int index, RouterInterceptor interceptor) {
        this._chainManager.addInterceptor(interceptor, index);
    }

    public void routerInterceptorIfAbsent(int index, RouterInterceptor interceptor) {
        this._chainManager.addInterceptorIfAbsent(interceptor, index);
    }

    public void before(Handler handler) {
        this.before("**", MethodType.ALL, handler);
    }

    public void before(int index, Handler handler) {
        this.before("**", MethodType.ALL, index, handler);
    }

    public void before(MethodType method, Handler handler) {
        this.before("**", method, handler);
    }

    public void before(MethodType method, int index, Handler handler) {
        this.before("**", method, index, handler);
    }

    public void before(String expr, Handler handler) {
        this.before(expr, MethodType.ALL, handler);
    }

    public void before(String expr, MethodType method, Handler handler) {
        this._router.add(expr, Endpoint.before, method, handler);
    }

    @Override
    public void before(String expr, MethodType method, int index, Handler handler) {
        this._router.add(expr, Endpoint.before, method, index, handler);
    }

    public void after(Handler handler) {
        this.after("**", MethodType.ALL, handler);
    }

    public void after(MethodType method, Handler handler) {
        this.after("**", method, handler);
    }

    public void after(String expr, Handler handler) {
        this.after(expr, MethodType.ALL, handler);
    }

    public void after(String expr, MethodType method, Handler handler) {
        this._router.add(expr, Endpoint.after, method, handler);
    }

    @Override
    public void after(String expr, MethodType method, int index, Handler handler) {
        this._router.add(expr, Endpoint.after, method, index, handler);
    }

    @Override
    public void add(String expr, MethodType method, Handler handler) {
        this._router.add(expr, Endpoint.main, method, handler);
    }

    public void add(String expr, Class<?> clz) {
        BeanWrap bw = this.context().wrapAndPut(clz);
        if (bw != null) {
            Solon.app().factoryManager().mvcFactory().createLoader(bw, expr).load(this);
        }
    }

    public void add(String expr, Class<?> clz, boolean remoting) {
        BeanWrap bw = this.context().wrapAndPut(clz);
        if (bw != null) {
            Solon.app().factoryManager().mvcFactory().createLoader(bw, expr, remoting).load(this);
        }
    }

    public void all(String path, Handler handler) {
        this.add(path, MethodType.ALL, handler);
    }

    public void http(String path, Handler handler) {
        this.add(path, MethodType.HTTP, handler);
    }

    public void head(String path, Handler handler) {
        this.add(path, MethodType.HEAD, handler);
    }

    public void get(String path, Handler handler) {
        this.add(path, MethodType.GET, handler);
    }

    public void post(String path, Handler handler) {
        this.add(path, MethodType.POST, handler);
    }

    public void put(String path, Handler handler) {
        this.add(path, MethodType.PUT, handler);
    }

    public void patch(String path, Handler handler) {
        this.add(path, MethodType.PATCH, handler);
    }

    public void delete(String path, Handler handler) {
        this.add(path, MethodType.DELETE, handler);
    }

    public void socketd(String path, Handler handler) {
        this.add(path, MethodType.SOCKET, handler);
    }
}

