/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.FactoryManager;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.ActionLoader;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;
import org.noear.solon.core.handle.FilterChainImpl;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerAide;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.MethodTypeUtil;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.route.RoutingDefault;
import org.noear.solon.core.route.RoutingTable;
import org.noear.solon.core.route.RoutingTableDefault;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.core.util.RankEntity;

public abstract class Gateway
extends HandlerAide
implements Handler,
Render {
    private Handler mainDef;
    private final RoutingTable<Handler> mainRouting;
    private final String mapping;
    private Mapping mappingAnno;
    private List<RankEntity<Filter>> filterList = new ArrayList<RankEntity<Filter>>();

    public RoutingTable<Handler> getMainRouting() {
        return this.mainRouting;
    }

    public Gateway() {
        this(new RoutingTableDefault<Handler>());
    }

    public Gateway(RoutingTable<Handler> routingTable) {
        this.mainRouting = routingTable;
        this.mappingAnno = this.getClass().getAnnotation(Mapping.class);
        if (this.mappingAnno == null) {
            throw new IllegalStateException("No Mapping!");
        }
        this.mapping = Utils.annoAlias(this.mappingAnno.value(), this.mappingAnno.path());
        this.mainDef = c -> c.status(404);
        this.filterList.add(new RankEntity<Filter>(this::doFilter, Integer.MAX_VALUE));
        Solon.context().lifecycle(() -> this.register());
    }

    protected abstract void register();

    protected boolean allowActionMapping() {
        return true;
    }

    protected boolean allowReadyController() {
        return true;
    }

    protected boolean allowPathMerging() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void render(Object obj, Context c) throws Throwable {
        if (obj instanceof DataThrowable) {
            return;
        }
        if (!c.getRendered()) {
            c.result = obj;
        }
        if (!(obj instanceof Throwable)) {
            if (c.getRendered()) return;
            c.render(obj);
            return;
        }
        if (c.remoting()) {
            Throwable objE = (Throwable)obj;
            LogUtil.global().warn("Gateway remoting handle failed!", objE);
            if (c.getRendered()) return;
            c.render(obj);
            return;
        }
        c.setHandled(false);
        throw (Throwable)obj;
    }

    public void filter(Filter filter) {
        this.filter(0, filter);
    }

    public void filter(int index, Filter filter) {
        this.filterList.add(new RankEntity<Filter>(filter, index));
        this.filterList.sort(Comparator.comparingInt(f -> f.index));
    }

    @Override
    public void handle(Context c) throws Throwable {
        try {
            new FilterChainImpl(this.filterList).doFilter(c);
        }
        catch (Throwable e) {
            c.setHandled(true);
            e = Utils.throwableUnwrap(e);
            if (e instanceof DataThrowable) {
                DataThrowable ex = (DataThrowable)e;
                if (ex.data() == null) {
                    this.render(ex, c);
                } else {
                    this.render(ex.data(), c);
                }
            }
            c.errors = e;
            this.render(e, c);
        }
    }

    protected void doFilter(Context c, FilterChain chain) throws Throwable {
        Handler m = this.find(c);
        Object obj = null;
        if (m != null) {
            Boolean is_action = m instanceof Action;
            if (is_action.booleanValue()) {
                if (this.allowReadyController()) {
                    obj = ((Action)m).controller().get(true);
                    c.attrSet("controller", obj);
                }
                c.attrSet("action", m);
            }
            this.handle0(c, m, obj, is_action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle0(Context c, Handler m, Object obj, Boolean is_action) throws Throwable {
        try {
            for (Handler h : this.befores()) {
                h.handle(c);
            }
            if (!c.getHandled()) {
                if (is_action.booleanValue()) {
                    ((Action)m).invoke(c, obj);
                } else {
                    m.handle(c);
                }
            } else {
                this.render(c.result, c);
            }
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap(e);
            if (e instanceof DataThrowable) {
                DataThrowable ex = (DataThrowable)e;
                if (ex.data() == null) {
                    this.render(ex, c);
                }
                this.render(ex.data(), c);
            }
            c.errors = e;
            throw e;
        }
        finally {
            for (Handler h : this.afters()) {
                h.handle(c);
            }
        }
    }

    public <T extends Handler> void before(Class<T> interceptorClz) {
        super.before((Handler)Solon.context().getBeanOrNew(interceptorClz));
    }

    public <T extends Handler> void after(Class<T> interceptorClz) {
        super.after((Handler)Solon.context().getBeanOrNew(interceptorClz));
    }

    public void addBeans(Predicate<BeanWrap> where) {
        this.addBeans(where, false);
    }

    public void addBeans(Predicate<BeanWrap> where, boolean remoting) {
        Solon.context().lifecycle(-98, () -> Solon.context().beanForeach(bw -> {
            if (where.test((BeanWrap)bw)) {
                if (remoting) {
                    this.add((BeanWrap)bw, remoting);
                } else {
                    this.add((BeanWrap)bw);
                }
            }
        }));
    }

    public void add(Class<?> beanClz) {
        if (beanClz != null) {
            BeanWrap bw = Solon.context().wrapAndPut(beanClz);
            this.add(bw, bw.remoting());
        }
    }

    public void add(String path, Class<?> beanClz) {
        if (beanClz != null) {
            BeanWrap bw = Solon.context().wrapAndPut(beanClz);
            this.add(path, bw, bw.remoting());
        }
    }

    public void add(Class<?> beanClz, boolean remoting) {
        if (beanClz != null) {
            this.add(Solon.context().wrapAndPut(beanClz), remoting);
        }
    }

    public void add(String path, Class<?> beanClz, boolean remoting) {
        if (beanClz != null) {
            this.add(path, Solon.context().wrapAndPut(beanClz), remoting);
        }
    }

    public void add(BeanWrap beanWp) {
        this.add(beanWp, beanWp.remoting());
    }

    public void add(String path, BeanWrap beanWp) {
        this.add(path, beanWp, beanWp.remoting());
    }

    public void add(BeanWrap beanWp, boolean remoting) {
        this.add(null, beanWp, remoting);
    }

    public void add(String path, BeanWrap beanWp, boolean remoting) {
        if (beanWp == null) {
            return;
        }
        Mapping bMapping = beanWp.clz().getAnnotation(Mapping.class);
        String bPath = null;
        if (bMapping != null) {
            bPath = Utils.annoAlias(bMapping.value(), bMapping.path());
        }
        ActionLoader uw = FactoryManager.mvcFactory().createHandlerLoader(beanWp, bPath, remoting, this, this.allowActionMapping());
        uw.load((expr, method, handler) -> {
            if (path == null) {
                this.addDo(expr, method, handler);
            } else {
                this.addDo(PathUtil.mergePath(path, expr), method, handler);
            }
        });
    }

    public void add(Handler handler) {
        this.addDo("", MethodType.ALL, handler);
    }

    public void add(String path, Handler handler) {
        this.addDo(path, MethodType.ALL, handler);
    }

    public void add(String path, MethodType method, Handler handler) {
        this.addDo(path, method, handler);
    }

    protected void addDo(String path, MethodType method, Handler handler) {
        if (Utils.isEmpty(path) || "/".equals(path)) {
            this.mainDef = handler;
            return;
        }
        if (this.allowPathMerging()) {
            String path2 = PathUtil.mergePath(this.mapping, path);
            this.mainRouting.add(new RoutingDefault<Handler>(path2, method, handler));
        } else {
            this.mainRouting.add(new RoutingDefault<Handler>(path, method, handler));
        }
    }

    protected Handler find(Context c) throws Throwable {
        if (this.mainRouting.count() == 0) {
            return this.findDo(c, null);
        }
        return this.findDo(c, c.pathNew());
    }

    protected Handler findDo(Context c, String path) throws Throwable {
        Handler h = path == null ? this.mainDef : this.getDo(c, path);
        if (h == null) {
            this.mainDef.handle(c);
            c.setHandled(true);
            return this.mainDef;
        }
        if (h instanceof Action) {
            c.attrSet("handler_name", ((Action)h).fullName());
        }
        return h;
    }

    protected Handler getDo(Context c, String path) {
        if (path == null) {
            return null;
        }
        MethodType method = MethodTypeUtil.valueOf(c.method());
        return this.mainRouting.matchOne(path, method);
    }
}

