/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.function.Function;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.MvcFactory;
import org.noear.solon.core.mvc.MvcFactoryDefault;

public final class FactoryManager {
    private static Function<Boolean, ThreadLocal> threadLocalFactory = inheritable -> {
        if (inheritable.booleanValue()) {
            return new InheritableThreadLocal();
        }
        return new ThreadLocal();
    };
    protected static LoadBalance.Factory loadBalanceFactory = (g, s) -> null;
    private static MvcFactory mvcFactory = new MvcFactoryDefault();

    public static <T> void threadLocalFactory(Function<Boolean, ThreadLocal> function) {
        if (function != null) {
            threadLocalFactory = function;
        }
    }

    public static <T> ThreadLocal<T> newThreadLocal(boolean inheritable) {
        return threadLocalFactory.apply(inheritable);
    }

    public static void loadBalanceFactory(LoadBalance.Factory factory) {
        if (factory != null) {
            loadBalanceFactory = factory;
        }
    }

    public static LoadBalance newLoadBalance(String group, String service) {
        return loadBalanceFactory.create(group, service);
    }

    public static boolean hasMvcFactory() {
        return mvcFactory != null;
    }

    public static MvcFactory mvcFactory() {
        if (mvcFactory == null) {
            throw new IllegalStateException("The 'solon.mvc' plugin is missing");
        }
        return mvcFactory;
    }

    public static void mvcFactory(MvcFactory factory) {
        if (factory != null) {
            mvcFactory = factory;
        }
    }
}

