/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.route.RoutingTable;

public class RoutingTableDefault<T>
implements RoutingTable<T> {
    private List<Routing<T>> table = new ArrayList<Routing<T>>();

    @Override
    public void add(Routing<T> routing) {
        this.table.add(routing);
    }

    @Override
    public void add(int index, Routing<T> routing) {
        this.table.add(index, routing);
    }

    @Override
    public void remove(String pathPrefix) {
        this.table.removeIf(l -> l.path().startsWith(pathPrefix));
    }

    @Override
    public int count() {
        return this.table.size();
    }

    @Override
    public Collection<Routing<T>> getAll() {
        return Collections.unmodifiableList(this.table);
    }

    @Override
    public T matchOne(String path, MethodType method) {
        for (Routing<T> l : this.table) {
            if (!l.matches(method, path)) continue;
            return l.target();
        }
        return null;
    }

    @Override
    public Result<T> matchOneAndStatus(String path, MethodType method) {
        int degrees = 0;
        for (Routing<T> l : this.table) {
            int tmp = l.degrees(method, path);
            if (tmp == 2) {
                return Result.succeed(l.target());
            }
            if (tmp <= degrees) continue;
            degrees = tmp;
        }
        if (degrees == 1) {
            return Result.failure(405);
        }
        return Result.failure(404);
    }

    @Override
    public List<T> matchMore(String path, MethodType method) {
        return this.table.stream().filter(l -> l.matches(method, path)).sorted(Comparator.comparingInt(l -> l.index())).map(l -> l.target()).collect(Collectors.toList());
    }

    @Override
    public void clear() {
        this.table.clear();
    }
}

