/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import org.noear.solon.annotation.Note;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.core.util.RunUtil;

public class LogUtil {
    private static LogUtil global;

    public static LogUtil global() {
        return global;
    }

    @Note(value="\u4e0d\u518d\u9700\u8981\u624b\u52a8\u8f6c\u53d1 slf4j \u4e86")
    @Deprecated
    public static void globalSet(LogUtil instance) {
    }

    public void infoAsync(String content) {
        RunUtil.async(() -> this.info(content));
    }

    public void trace(String content) {
        System.out.print("[Solon] ");
        PrintUtil.purpleln(content);
    }

    public void debug(String content) {
        System.out.print("[Solon] ");
        PrintUtil.blueln(content);
    }

    public void info(String content) {
        System.out.println("[Solon] " + content);
    }

    public void warn(String content) {
        this.warn(content, null);
    }

    public void warn(String content, Throwable throwable) {
        System.out.print("[Solon] ");
        PrintUtil.yellowln("WARN: " + content);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public void error(String content) {
        this.error(content, null);
    }

    public void error(String content, Throwable throwable) {
        System.out.print("[Solon] ");
        PrintUtil.redln("ERROR: " + content);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    static {
        LogUtil ext = (LogUtil)ClassUtil.tryInstance("org.noear.solon.extend.impl.LogUtilExt");
        global = ext == null ? new LogUtil() : ext;
    }
}

