/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.core.event.EventListenPipeline;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.exception.EventException;
import org.noear.solon.core.util.GenericUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.RunUtil;

public final class EventBus {
    private static List<HH> sThrow = new ArrayList<HH>();
    private static List<HH> sOther = new ArrayList<HH>();
    private static Map<Class<?>, EventListenPipeline<?>> sPipeline = new HashMap();

    public static void publishAsync(Object event) {
        if (event != null) {
            RunUtil.async(() -> {
                try {
                    EventBus.publish0(event);
                }
                catch (Throwable e) {
                    EventBus.publish(e);
                }
            });
        }
    }

    @Deprecated
    public static void pushAsync(Object event) {
        EventBus.publishAsync(event);
    }

    public static void publishTry(Object event) {
        if (event != null) {
            try {
                EventBus.publish0(event);
            }
            catch (Throwable e) {
                LogUtil.global().warn(e.getMessage(), e);
            }
        }
    }

    @Deprecated
    public static void pushTry(Object event) {
        EventBus.publishTry(event);
    }

    public static void publish(Object event) throws RuntimeException {
        if (event != null) {
            try {
                EventBus.publish0(event);
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new EventException("Event execution failed: " + event.getClass().getName(), e);
            }
        }
    }

    @Deprecated
    public static void push(Object event) throws RuntimeException {
        EventBus.publish(event);
    }

    private static void publish0(Object event) throws Throwable {
        if (event instanceof Throwable) {
            if (Solon.app() == null || Solon.app().enableErrorAutoprint()) {
                ((Throwable)event).printStackTrace();
            }
            EventBus.publish1(sThrow, event, false);
        } else {
            EventBus.publish1(sOther, event, true);
        }
    }

    private static void publish1(List<HH> hhs, Object event, boolean thrown) throws Throwable {
        for (int i = 0; i < hhs.size(); ++i) {
            HH h1 = hhs.get(i);
            if (!h1.t.isInstance(event)) continue;
            try {
                h1.l.onEvent(event);
                continue;
            }
            catch (Throwable e) {
                if (thrown) {
                    throw e;
                }
                e.printStackTrace();
            }
        }
    }

    public static synchronized <T> void subscribe(Class<T> eventType, EventListener<T> listener) {
        EventBus.pipelineDo(eventType).add(listener);
    }

    public static synchronized <T> void subscribe(Class<T> eventType, int index, EventListener<T> listener) {
        EventBus.pipelineDo(eventType).add(index, listener);
    }

    private static <T> EventListenPipeline<T> pipelineDo(Class<T> eventType) {
        EventListenPipeline<Object> pipeline = sPipeline.get(eventType);
        if (pipeline == null) {
            pipeline = new EventListenPipeline();
            sPipeline.put(eventType, pipeline);
            EventBus.registerDo(eventType, pipeline);
        }
        return pipeline;
    }

    private static <T> void registerDo(Class<T> eventType, EventListener<T> listener) {
        if (Throwable.class.isAssignableFrom(eventType)) {
            sThrow.add(new HH(eventType, listener));
            if (Solon.app() != null) {
                Solon.app().enableErrorAutoprint(false);
            }
        } else {
            sOther.add(new HH(eventType, listener));
        }
    }

    public static synchronized <T> void unsubscribe(EventListener<T> listener) {
        Class<?>[] ets = GenericUtil.resolveTypeArguments(listener.getClass(), EventListener.class);
        if (ets != null && ets.length > 0) {
            EventBus.pipelineDo(ets[0]).remove(listener);
        }
    }

    static class HH {
        protected Class<?> t;
        protected EventListener l;

        public HH(Class<?> type, EventListener listener) {
            this.t = type;
            this.l = listener;
        }
    }
}

