/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.noear.solon.Utils;
import org.noear.solon.annotation.PropertySource;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.Props;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.PluginUtil;
import org.noear.solon.core.util.ResourceUtil;

public final class SolonProps
extends Props {
    private NvMap args;
    private Class<?> source;
    private URL sourceLocation;
    private boolean testing;
    private final List<PluginEntity> plugs = new ArrayList<PluginEntity>();
    private boolean isDebugMode;
    private boolean isDriftMode;
    private boolean isFilesMode;
    private boolean isWhiteMode;
    private boolean isSetupMode;
    private boolean isAloneMode;
    private String env;
    private Locale locale;
    private String extend;
    private String extendFilter;
    private int serverPort;
    private String serverHost;
    private Integer serverWrapPort;
    private String serverWrapHost;
    private String serverContextPath;
    Boolean stopSafe;
    Integer stopDelay;

    public SolonProps() {
        super(System.getProperties());
    }

    public SolonProps load(Class<?> source, NvMap args) throws Exception {
        this.args = args;
        this.source = source;
        this.sourceLocation = source.getProtectionDomain().getCodeSource().getLocation();
        this.testing = args.containsKey("testing");
        this.syncArgsToSys();
        Properties sysPropOrg = new Properties();
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> sysPropOrg.put(k, v)));
        URL appUrl = ResourceUtil.getResource("application.properties");
        if (appUrl != null) {
            this.loadInit(appUrl, sysPropOrg);
            this.profileWran("application.properties");
        }
        if ((appUrl = ResourceUtil.getResource("application.yml")) != null) {
            this.loadInit(appUrl, sysPropOrg);
            this.profileWran("application.yml");
        }
        this.loadInit(ResourceUtil.getResource("app.properties"), sysPropOrg);
        this.loadInit(ResourceUtil.getResource("app.yml"), sysPropOrg);
        this.loadEnv((String k) -> k.startsWith("solon.") || k.startsWith("server."));
        this.env = this.getArg("env");
        if (Utils.isNotEmpty(this.env)) {
            appUrl = ResourceUtil.getResource("application-" + this.env + ".properties");
            if (appUrl != null) {
                this.loadInit(appUrl, sysPropOrg);
                this.profileWran("application-" + this.env + ".properties");
            }
            if ((appUrl = ResourceUtil.getResource("application-" + this.env + ".yml")) != null) {
                this.loadInit(appUrl, sysPropOrg);
                this.profileWran("application-" + this.env + ".yml");
            }
            this.loadInit(ResourceUtil.getResource("app-" + this.env + ".properties"), sysPropOrg);
            this.loadInit(ResourceUtil.getResource("app-" + this.env + ".yml"), sysPropOrg);
        }
        this.loadAdd(source.getAnnotation(PropertySource.class));
        TreeMap loadKeyMap = new TreeMap();
        this.doFind("solon.config.load", (key, val) -> {
            if (key.equals("") || key.startsWith("[")) {
                loadKeyMap.put(key, val);
            }
        });
        for (String loadKey : loadKeyMap.values()) {
            this.addConfig(loadKey, true, sysPropOrg);
        }
        this.addConfig(this.getArg("config"), false, sysPropOrg);
        this.addConfig(this.getArg("config.add"), false, sysPropOrg);
        this.isFilesMode = !this.sourceLocation.getPath().endsWith(".jar") && !this.sourceLocation.getPath().contains(".jar!/") && !this.sourceLocation.getPath().endsWith(".zip") && !this.sourceLocation.getPath().contains(".zip!/");
        this.isDebugMode = "1".equals(this.getArg("debug"));
        this.isSetupMode = "1".equals(this.getArg("setup"));
        this.isWhiteMode = "1".equals(this.getArg("white"));
        this.isDriftMode = "1".equals(this.getArg("drift"));
        this.isAloneMode = "1".equals(this.getArg("alone"));
        if (this.isDebugMode()) {
            System.setProperty("debug", "1");
        }
        this.extend = this.getArg("extend");
        this.extendFilter = this.getArg("extend.filter");
        String localeStr = this.getArg("locale");
        if (Utils.isNotEmpty(localeStr)) {
            this.locale = Utils.toLocale(localeStr);
            Locale.setDefault(this.locale);
        } else {
            this.locale = Locale.getDefault();
        }
        return this;
    }

    private void addConfig(String vals, boolean isName, Properties sysPropOrg) {
        if (Utils.isNotEmpty(vals)) {
            for (String val : vals.split(",")) {
                URL propUrl;
                URL uRL = propUrl = isName ? ResourceUtil.getResource(val) : ResourceUtil.findResource(val);
                if (propUrl == null) {
                    LogUtil.global().warn("Props: No config file: " + val);
                    continue;
                }
                this.loadInit(propUrl, sysPropOrg);
            }
        }
    }

    private void profileWran(String file) {
        String sml = file.replace("application", "app");
        LogUtil.global().warn("'" + file + "' is deprecated, please use '" + sml + "'");
    }

    private void syncArgsToSys() {
        this.args.forEach((? super K k, ? super V v) -> {
            if (k.contains(".")) {
                System.setProperty(k, v);
            }
        });
        this.syncArgToSys("env");
        this.syncArgToSys("app.name");
        this.syncArgToSys("app.group");
        this.syncArgToSys("app.namespace");
        this.syncArgToSys("app.title");
        this.syncArgToSys("stop.safe");
        this.syncArgToSys("stop.delay");
    }

    private void syncArgToSys(String name) {
        String val = (String)this.args.get(name);
        if (val != null) {
            System.setProperty("solon." + name, val);
        }
    }

    private String getArg(String name) {
        String val = (String)this.args.get(name);
        if (val == null) {
            val = this.get("solon." + name);
        }
        return val;
    }

    public SolonProps loadEnv(String keyStarts) {
        return this.loadEnv((String k) -> k.startsWith(keyStarts));
    }

    public SolonProps loadEnv(Predicate<String> condition) {
        System.getenv().forEach((? super K k, ? super V v) -> {
            if (condition.test((String)k)) {
                this.setProperty((String)k, (String)v);
                System.setProperty(k, v);
            }
        });
        return this;
    }

    @Override
    public void loadAdd(Properties props) {
        this.loadAddDo(props, !this.testing, false);
    }

    protected void loadInit(URL url, Properties sysPropOrg) {
        if (url == null) {
            return;
        }
        Properties props = Utils.loadProperties(url);
        if (props == null) {
            return;
        }
        for (Map.Entry<Object, Object> kv : sysPropOrg.entrySet()) {
            String key;
            if (!(kv.getKey() instanceof String) || Utils.isEmpty(key = (String)kv.getKey()) || !props.containsKey(key)) continue;
            props.put(key, kv.getValue());
        }
        this.loadAdd(props);
    }

    protected void plugsScan(List<ClassLoader> classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            PluginUtil.scanPlugins(classLoader, null, this.plugs::add);
        }
        PluginUtil.findPlugins(AppClassLoader.global(), this, this.plugs::add);
        this.plugsSort();
    }

    public Class<?> source() {
        return this.source;
    }

    public URL sourceLocation() {
        return this.sourceLocation;
    }

    public NvMap argx() {
        return this.args;
    }

    public List<PluginEntity> plugs() {
        return this.plugs;
    }

    public void plugsSort() {
        if (this.plugs.size() > 0) {
            this.plugs.sort(Comparator.comparingInt(PluginEntity::getPriority).reversed());
        }
    }

    public int serverPort() {
        if (this.serverPort == 0) {
            this.serverPort = this.getInt("server.port", 8080);
        }
        return this.serverPort;
    }

    public String serverHost() {
        if (this.serverHost == null) {
            this.serverHost = this.get("server.host", "");
        }
        return this.serverHost;
    }

    public int serverWrapPort(boolean raw) {
        if (this.serverWrapPort == null) {
            this.serverWrapPort = this.getInt("server.wrapPort", 0);
        }
        if (raw || this.serverWrapPort > 0) {
            return this.serverWrapPort;
        }
        return this.serverPort();
    }

    public String serverWrapHost(boolean raw) {
        if (this.serverWrapHost == null) {
            this.serverWrapHost = this.get("server.wrapHost", "");
        }
        if (raw || Utils.isNotEmpty(this.serverWrapHost)) {
            return this.serverWrapHost;
        }
        return this.serverHost();
    }

    public String serverContextPath() {
        if (this.serverContextPath == null) {
            String path = this.get("server.contextPath", "").trim();
            this.serverContextPath(path);
        }
        return this.serverContextPath;
    }

    public void serverContextPath(String path) {
        this.serverContextPath = path == null ? "" : path;
        if (this.serverContextPath.length() > 0) {
            if (!this.serverContextPath.startsWith("/")) {
                this.serverContextPath = "/" + this.serverContextPath;
            }
            if (!this.serverContextPath.endsWith("/")) {
                this.serverContextPath = this.serverContextPath + "/";
            }
        }
    }

    public String env() {
        return this.env;
    }

    public boolean testing() {
        return this.testing;
    }

    public Locale locale() {
        return this.locale;
    }

    public String extend() {
        return this.extend;
    }

    public String extendFilter() {
        return this.extendFilter;
    }

    public String appName() {
        return this.get("solon.app.name");
    }

    public String appGroup() {
        return this.get("solon.app.group");
    }

    public String appNamespace() {
        return this.get("solon.app.namespace");
    }

    public String appTitle() {
        return this.get("solon.app.title");
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public boolean isSetupMode() {
        return this.isSetupMode;
    }

    public boolean isFilesMode() {
        return this.isFilesMode;
    }

    public void isFilesMode(boolean value) {
        this.isFilesMode = value;
    }

    public boolean isDriftMode() {
        return this.isDriftMode;
    }

    public void isDriftMode(boolean value) {
        this.isDriftMode = value;
    }

    public boolean isAloneMode() {
        return this.isAloneMode;
    }

    public void isAloneMode(boolean value) {
        this.isAloneMode = value;
    }

    public boolean isWhiteMode() {
        return this.isWhiteMode;
    }

    public void isWhiteMode(boolean value) {
        this.isWhiteMode = value;
    }

    public boolean stopSafe() {
        if (this.stopSafe == null) {
            this.stopSafe = "1".equals("solon.stop.safe");
        }
        return this.stopSafe;
    }

    public void stopSafe(boolean value) {
        this.stopSafe = value;
    }

    public int stopDelay() {
        if (this.stopDelay == null) {
            this.stopDelay = Integer.parseInt(this.get("solon.stop.delay", "10s").replace("s", ""));
        }
        return this.stopDelay;
    }
}

