/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Init;
import org.noear.solon.annotation.Singleton;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.IndexBuilder;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.wrap.ClassWrap;

public class BeanWrap {
    private Class<?> clz;
    private Method clzInit;
    private int clzInitIndex;
    private Object raw;
    private Object rawUnproxied;
    private boolean singleton;
    private boolean remoting;
    private String name;
    private int index;
    private String tag;
    private boolean typed;
    private Proxy proxy;
    private final Annotation[] annotations;
    private final AppContext context;

    public BeanWrap(AopContext context, Class<?> clz) {
        this(context, clz, null);
    }

    public BeanWrap(AopContext context, Class<?> clz, Object raw) {
        this(context, clz, raw, null);
    }

    public BeanWrap(AopContext context, Class<?> clz, Object raw, String name) {
        this(context, clz, raw, name, false);
    }

    public BeanWrap(AopContext context, Class<?> clz, Object raw, String name, boolean typed) {
        this.context = (AppContext)context;
        this.clz = clz;
        this.name = name;
        this.typed = typed;
        Singleton anoS = clz.getAnnotation(Singleton.class);
        this.singleton = anoS == null || anoS.value();
        this.annotations = clz.getAnnotations();
        this.tryBuildInit();
        if (raw == null) {
            this.raw = this.rawUnproxied = this._new();
        } else {
            this.rawUnproxied = raw;
            this.raw = raw;
        }
        this.tryInit(this.raw);
    }

    public AppContext context() {
        return this.context;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public void proxySet(Proxy proxy) {
        this.proxy = proxy;
        if (this.raw != null) {
            this.raw = proxy.getProxy(this.context(), this.raw);
        }
    }

    public boolean singleton() {
        return this.singleton;
    }

    public void singletonSet(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean remoting() {
        return this.remoting;
    }

    public void remotingSet(boolean remoting) {
        this.remoting = remoting;
    }

    public Class<?> clz() {
        return this.clz;
    }

    public Method clzInit() {
        return this.clzInit;
    }

    public <T> T raw(boolean unproxied) {
        if (unproxied) {
            return (T)this.rawUnproxied;
        }
        return (T)this.raw;
    }

    public <T> T raw() {
        return this.raw(false);
    }

    protected void rawSet(Object raw) {
        this.raw = raw;
    }

    public String name() {
        return this.name;
    }

    protected void nameSet(String name) {
        this.name = name;
    }

    public int index() {
        return this.index;
    }

    protected void indexSet(int index) {
        this.index = index;
    }

    public String tag() {
        return this.tag;
    }

    protected void tagSet(String tag) {
        this.tag = tag;
    }

    public boolean typed() {
        return this.typed;
    }

    protected void typedSet(boolean typed) {
        this.typed = typed;
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    public <T extends Annotation> T annotationGet(Class<T> annClz) {
        return this.clz.getAnnotation(annClz);
    }

    public <T> T get() {
        return this.get(false);
    }

    public <T> T get(boolean unproxied) {
        if (unproxied) {
            if (this.singleton) {
                return (T)this.rawUnproxied;
            }
            return (T)this._new();
        }
        if (this.singleton) {
            return (T)this.raw;
        }
        Object tmp = this._new();
        if (this.proxy != null) {
            tmp = this.proxy.getProxy(this.context(), tmp);
        }
        return (T)tmp;
    }

    protected Object _new() {
        if (this.clz.isInterface()) {
            return this.raw;
        }
        try {
            Object bean = ClassUtil.newInstance(this.clz);
            this.context.beanInject(bean);
            return bean;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Instantiation failure: " + this.clz.getTypeName(), ex);
        }
    }

    protected void tryInit(Object bean) {
        if (bean == null) {
            return;
        }
        if (this.clzInit != null) {
            if (this.clzInitIndex == 0) {
                this.clzInitIndex = new IndexBuilder().buildIndex(this.clz);
            }
            this.context.lifecycle(this.clzInitIndex + 1, () -> {
                try {
                    this.clzInit.invoke(bean, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    Throwable e2 = e.getTargetException();
                    throw Utils.throwableUnwrap(e2);
                }
            });
        }
    }

    protected void tryBuildInit() {
        if (this.clzInit != null) {
            return;
        }
        if (this.clz.isInterface()) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(this.clz);
        for (Method m : clzWrap.getMethods()) {
            Init initAnno = m.getAnnotation(Init.class);
            if (initAnno == null) continue;
            if (m.getParameters().length != 0) break;
            this.clzInit = m;
            this.clzInit.setAccessible(true);
            this.clzInitIndex = initAnno.index();
            if (!Solon.cfg().isDebugMode()) break;
            LogUtil.global().warn("@Init will be discarded, suggested use 'LifecycleBean' interface");
            break;
        }
    }

    @FunctionalInterface
    public static interface Proxy {
        public Object getProxy(AppContext var1, Object var2);
    }
}

