/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.AnnotatedElement;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Condition;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.util.ClassUtil;

public class ConditionUtil {
    public static boolean ifMissing(Condition anno) {
        if (anno == null) {
            return false;
        }
        try {
            return anno.onMissingBean() != Void.class || Utils.isNotEmpty(anno.onMissingBeanName());
        }
        catch (Throwable e) {
            return true;
        }
    }

    public static boolean test(AopContext context, AnnotatedElement element) {
        Condition anno = element.getAnnotation(Condition.class);
        return ConditionUtil.test(context, anno);
    }

    public static boolean test(AopContext context, Condition anno) {
        if (anno == null) {
            return true;
        }
        return !ConditionUtil.testNo(context, anno);
    }

    private static boolean testNo(AopContext context, Condition anno) {
        try {
            anno.onClass();
        }
        catch (Throwable e) {
            return true;
        }
        if (Utils.isNotEmpty(anno.onClassName()) && ClassUtil.loadClass(context.getClassLoader(), anno.onClassName()) == null) {
            return true;
        }
        if (Utils.isNotEmpty(anno.onProperty())) {
            String[] kv = anno.onProperty().split("=");
            if (kv.length > 1) {
                String val = context.cfg().getByExpr(kv[0].trim());
                if (!kv[1].trim().equals(val)) {
                    return true;
                }
            } else {
                String val = context.cfg().getByExpr(anno.onProperty());
                if (!Utils.isNotEmpty(val)) {
                    return true;
                }
            }
        }
        try {
            if (anno.onMissingBean() != Void.class && context.hasWrap(anno.onMissingBean())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Utils.isNotEmpty(anno.onMissingBeanName()) && context.hasWrap(anno.onMissingBeanName());
    }
}

