/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;

public class ActionExecuteHandlerDefault
implements ActionExecuteHandler {
    @Override
    public boolean matched(Context ctx, String ct) {
        return true;
    }

    @Override
    public Object executeHandle(Context ctx, Object obj, MethodWrap mWrap) throws Throwable {
        List<Object> args = this.buildArgs(ctx, mWrap);
        return mWrap.invokeByAspect(obj, args.toArray());
    }

    protected List<Object> buildArgs(Context ctx, MethodWrap mWrap) throws Exception {
        ParamWrap[] pSet = mWrap.getParamWraps();
        ArrayList<Object> args = new ArrayList<Object>(pSet.length);
        Object bodyObj = this.changeBody(ctx, mWrap);
        int len = pSet.length;
        for (int i = 0; i < len; ++i) {
            ParamWrap p = pSet[i];
            Class<?> pt = p.getType();
            if (Context.class.isAssignableFrom(pt)) {
                args.add(ctx);
                continue;
            }
            if (ModelAndView.class.isAssignableFrom(pt)) {
                args.add(new ModelAndView());
                continue;
            }
            if (Locale.class.isAssignableFrom(pt)) {
                args.add(ctx.getLocale());
                continue;
            }
            if (UploadedFile.class == pt) {
                args.add(ctx.file(p.getName()));
                continue;
            }
            if (pt.isInstance(ctx.request())) {
                args.add(ctx.request());
                continue;
            }
            if (pt.isInstance(ctx.response())) {
                args.add(ctx.response());
                continue;
            }
            Object tv = null;
            if (p.isRequiredBody()) {
                if (String.class.equals(pt)) {
                    tv = ctx.bodyNew();
                } else if (InputStream.class.equals(pt)) {
                    tv = ctx.bodyAsStream();
                } else if (Map.class.equals(pt) && bodyObj instanceof NvMap) {
                    tv = bodyObj;
                }
            }
            if (tv == null) {
                try {
                    tv = this.changeValue(ctx, p, i, pt, bodyObj);
                }
                catch (Exception e) {
                    String methodFullName = mWrap.getEntityClz().getName() + "::" + mWrap.getName() + "@" + p.getName();
                    throw new IllegalArgumentException("Action parameter change failed: " + methodFullName, e);
                }
            }
            if (tv == null && pt.isPrimitive()) {
                if (pt == Short.TYPE) {
                    tv = (short)0;
                } else if (pt == Integer.TYPE) {
                    tv = 0;
                } else if (pt == Long.TYPE) {
                    tv = 0L;
                } else if (pt == Double.TYPE) {
                    tv = 0.0;
                } else if (pt == Float.TYPE) {
                    tv = Float.valueOf(0.0f);
                } else if (pt == Boolean.TYPE) {
                    tv = false;
                } else {
                    throw new IllegalArgumentException("Please enter a valid parameter @" + p.getName());
                }
            }
            if (tv == null && p.isRequiredInput()) {
                ctx.status(400);
                throw new IllegalArgumentException(p.getRequiredHint());
            }
            args.add(tv);
        }
        return args;
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return ctx.paramMap();
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        String pn = p.getName();
        String pv = p.getValue(ctx);
        Object tv = null;
        if (pv == null) {
            pv = p.getDefaultValue();
        }
        tv = pv == null ? (UploadedFile.class == pt ? ctx.file(pn) : (UploadedFile[].class == pt ? Utils.toArray(ctx.files(pn), new UploadedFile[0]) : (pn.startsWith("$") ? ctx.attr(pn) : (pt.getName().startsWith("java.") || pt.isArray() || pt.isPrimitive() ? null : this.changeEntityDo(ctx, p, pn, pt))))) : this.changeValueDo(ctx, p, pn, pt, pv);
        return tv;
    }

    protected Object changeValueDo(Context ctx, ParamWrap p, String name, Class<?> type, String value) {
        return ConvertUtil.to(p, value, ctx);
    }

    protected Object changeEntityDo(Context ctx, ParamWrap p, String name, Class<?> type) throws Exception {
        ClassWrap clzW = ClassWrap.get(type);
        NvMap map = ctx.paramMap();
        return clzW.newBy(map::get, ctx);
    }
}

