/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.event;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.exception.EventException;
import org.noear.solon.core.util.RunUtil;

public final class EventBus {
    private static Map<Object, HH> sThrow = new HashMap<Object, HH>();
    private static Map<Object, HH> sOther = new HashMap<Object, HH>();

    public static void pushAsync(Object event) {
        if (event != null) {
            RunUtil.async(() -> {
                try {
                    EventBus.push0(event);
                }
                catch (Throwable e) {
                    EventBus.push(e);
                }
            });
        }
    }

    public static void push(Object event) throws RuntimeException {
        if (event != null) {
            try {
                EventBus.push0(event);
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new EventException("Event execution failed: " + event.getClass().getName(), e);
            }
        }
    }

    public static void pushTry(Object event) {
        if (event != null) {
            try {
                EventBus.push0(event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void push0(Object event) throws Throwable {
        if (event instanceof Throwable) {
            if (Solon.app() == null || Solon.app().enableErrorAutoprint()) {
                ((Throwable)event).printStackTrace();
            }
            EventBus.push1(sThrow.values(), event, false);
        } else {
            EventBus.push1(sOther.values(), event, true);
        }
    }

    private static void push1(Collection<HH> hhs, Object event, boolean thrown) throws Throwable {
        for (HH h1 : hhs) {
            if (!h1.t.isInstance(event)) continue;
            try {
                h1.l.onEvent(event);
            }
            catch (Throwable e) {
                if (thrown) {
                    throw e;
                }
                e.printStackTrace();
            }
        }
    }

    public static synchronized <T> void subscribe(Class<T> eventType, EventListener<T> listener) {
        if (Throwable.class.isAssignableFrom(eventType)) {
            sThrow.putIfAbsent(listener, new HH(eventType, listener));
            if (Solon.app() != null) {
                Solon.app().enableErrorAutoprint(false);
            }
        } else {
            sOther.putIfAbsent(listener, new HH(eventType, listener));
        }
    }

    public static synchronized <T> void unsubscribe(EventListener<T> listener) {
        sThrow.remove(listener);
        sOther.remove(listener);
    }

    static class HH {
        protected Class<?> t;
        protected EventListener l;

        public HH(Class<?> type, EventListener listener) {
            this.t = type;
            this.l = listener;
        }
    }
}

