/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.ActionExecuteHandlerDefault;
import org.noear.solon.core.handle.ActionReturnHandler;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChainImpl;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.PathLimiter;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.RouterInterceptorChainImpl;
import org.noear.solon.core.route.RouterInterceptorLimiter;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.lang.Nullable;

public class ChainManager {
    private final List<RankEntity<Filter>> filterNodes = new ArrayList<RankEntity<Filter>>();
    private final List<RankEntity<RouterInterceptor>> interceptorNodes = new ArrayList<RankEntity<RouterInterceptor>>();
    private final Map<Class<?>, ActionReturnHandler> returnHandlers = new LinkedHashMap();
    private ActionExecuteHandler executeHandlerDefault = new ActionExecuteHandlerDefault();
    private Map<Class<?>, ActionExecuteHandler> executeHandlers = new LinkedHashMap();

    public List<RankEntity<Filter>> getFilterNodes() {
        return Collections.unmodifiableList(this.filterNodes);
    }

    public synchronized void addFilter(Filter filter, int index) {
        this.filterNodes.add(new RankEntity<Filter>(filter, index));
        this.filterNodes.sort(Comparator.comparingInt(f -> f.index));
    }

    public void doFilter(Context x) throws Throwable {
        new FilterChainImpl(this.filterNodes).doFilter(x);
    }

    public List<RankEntity<RouterInterceptor>> getInterceptorNodes() {
        return Collections.unmodifiableList(this.interceptorNodes);
    }

    public synchronized void addInterceptor(RouterInterceptor interceptor, int index) {
        if (interceptor instanceof PathLimiter) {
            interceptor = new RouterInterceptorLimiter(interceptor, ((PathLimiter)((Object)interceptor)).pathRule());
        }
        this.interceptorNodes.add(new RankEntity<RouterInterceptor>(interceptor, index));
        this.interceptorNodes.sort(Comparator.comparingInt(f -> f.index));
    }

    public void doIntercept(Context x, @Nullable Handler mainHandler) throws Throwable {
        new RouterInterceptorChainImpl(this.interceptorNodes).doIntercept(x, mainHandler);
    }

    public Object postResult(Context x, @Nullable Object result) throws Throwable {
        for (RankEntity<RouterInterceptor> e : this.interceptorNodes) {
            result = ((RouterInterceptor)e.target).postResult(x, result);
        }
        return result;
    }

    public void addReturnHandler(ActionReturnHandler e) {
        if (e != null) {
            this.returnHandlers.put(e.getClass(), e);
        }
    }

    public ActionReturnHandler getReturnHandler(Class<?> returnType) {
        for (ActionReturnHandler handler : this.returnHandlers.values()) {
            if (!handler.matched(returnType)) continue;
            return handler;
        }
        return null;
    }

    public void addExecuteHandler(ActionExecuteHandler e) {
        if (e != null) {
            this.executeHandlers.put(e.getClass(), e);
        }
    }

    public void removeExecuteHandler(Class<?> clz) {
        this.executeHandlers.remove(clz);
    }

    public ActionExecuteHandler getExecuteHandler(Context c, int paramSize) {
        String ct = c.contentType();
        if (ct != null && paramSize > 0) {
            for (ActionExecuteHandler me : this.executeHandlers.values()) {
                if (!me.matched(c, ct)) continue;
                return me;
            }
        }
        return this.executeHandlerDefault;
    }

    public ActionExecuteHandler getExecuteHandlerDefault() {
        return this.executeHandlerDefault;
    }
}

