/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.handle.ActionExecutor;
import org.noear.solon.core.handle.ActionExecutorDefault;
import org.noear.solon.core.handle.ActionReturnHandler;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.handle.SessionStateEmpty;
import org.noear.solon.core.handle.SessionStateFactory;

public class Bridge {
    private static SessionStateFactory _sessionStateFactory = ctx -> new SessionStateEmpty();
    private static boolean sessionStateUpdated;
    private static LoadBalance.Factory _upstreamFactory;
    private static ActionExecutor _actionExecutorDef;
    private static Map<Class<?>, ActionExecutor> _actionExecutors;
    public static final Map<Class<?>, ActionReturnHandler> actionReturnHandlers;

    public static SessionStateFactory sessionStateFactory() {
        return _sessionStateFactory;
    }

    public static void sessionStateFactorySet(SessionStateFactory ssf) {
        if (ssf != null) {
            _sessionStateFactory = ssf;
            if (!sessionStateUpdated) {
                sessionStateUpdated = true;
                Solon.app().before("**", MethodType.HTTP, c -> c.sessionState().sessionRefresh());
            }
        }
    }

    public static SessionState sessionState(Context ctx) {
        return _sessionStateFactory.create(ctx);
    }

    public static LoadBalance.Factory upstreamFactory() {
        return _upstreamFactory;
    }

    public static void upstreamFactorySet(LoadBalance.Factory uf) {
        if (uf != null) {
            _upstreamFactory = uf;
        }
    }

    public static ActionExecutor actionExecutorDef() {
        return _actionExecutorDef;
    }

    public static void actionExecutorDefSet(ActionExecutor ae) {
        if (ae != null) {
            _actionExecutorDef = ae;
        }
    }

    public static Collection<ActionExecutor> actionExecutors() {
        return Collections.unmodifiableCollection(_actionExecutors.values());
    }

    public static void actionExecutorAdd(ActionExecutor e) {
        if (e != null) {
            _actionExecutors.put(e.getClass(), e);
        }
    }

    public static void actionExecutorRemove(Class<?> clz) {
        _actionExecutors.remove(clz);
    }

    static {
        _upstreamFactory = (g, s) -> null;
        _actionExecutorDef = new ActionExecutorDefault();
        _actionExecutors = new HashMap();
        actionReturnHandlers = new HashMap();
    }
}

