/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.util.SupplierEx;

public class ClassUtil {
    public static boolean hasClass(SupplierEx<Class<?>> test) {
        try {
            test.get();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Class<?> loadClass(String className) {
        return ClassUtil.loadClass(null, className);
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            if (classLoader == null) {
                return Class.forName(className);
            }
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T tryInstance(String className) {
        return ClassUtil.tryInstance(className, null);
    }

    public static <T> T tryInstance(String className, Properties prop) {
        return ClassUtil.tryInstance(JarClassLoader.global(), className, prop);
    }

    public static <T> T tryInstance(ClassLoader classLoader, String className) {
        return ClassUtil.tryInstance(classLoader, className, null);
    }

    public static <T> T tryInstance(ClassLoader classLoader, String className, Properties prop) {
        Class<?> clz = ClassUtil.loadClass(classLoader, className);
        if (clz == null) {
            return null;
        }
        try {
            return ClassUtil.newInstance(clz, prop);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Deprecated
    public static <T> T newInstance(String className) {
        return ClassUtil.tryInstance(className);
    }

    @Deprecated
    public static <T> T newInstance(String className, Properties prop) {
        return ClassUtil.tryInstance(className, prop);
    }

    @Deprecated
    public static <T> T newInstance(ClassLoader classLoader, String className) {
        return ClassUtil.tryInstance(classLoader, className);
    }

    @Deprecated
    public static <T> T newInstance(ClassLoader classLoader, String className, Properties prop) {
        return ClassUtil.tryInstance(classLoader, className, prop);
    }

    public static <T> T newInstance(Class<?> clz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        return ClassUtil.newInstance(clz, null);
    }

    public static <T> T newInstance(Class<?> clz, Properties prop) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        if (prop == null) {
            return (T)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return (T)clz.getConstructor(Properties.class).newInstance(prop);
    }
}

