/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.annotation.Inject;

public class IndexBuilder {
    private final Map<String, Integer> map = new HashMap<String, Integer>();
    private final ArrayList<String> classStack = new ArrayList();

    public int buildIndex(Class<?> clazz) {
        return this.buildIndexDo(clazz, true);
    }

    private int buildIndexDo(Class<?> clazz, Boolean stackTop) {
        if (stackTop.booleanValue()) {
            this.classStack.clear();
            if (this.isLoopRelate(clazz, clazz.getName())) {
                String link = "";
                for (int i = 0; i < this.classStack.size(); ++i) {
                    link = link + this.classStack.get(i);
                    if (i == this.classStack.size() - 1) continue;
                    link = link + " -> ";
                }
                throw new IllegalStateException("Lifecycle does not support dependency loops: " + link);
            }
        }
        if (this.map.get(clazz.getName()) != null) {
            return this.map.get(clazz.getName());
        }
        List<Class<?>> clazzList = this.findRelateClass(clazz);
        if (clazzList.size() == 0) {
            this.map.put(clazz.getName(), 0);
            return 0;
        }
        Integer maxIndex = null;
        for (Class<?> clazzRelate : clazzList) {
            if (this.classStack.contains(clazzRelate.getName())) continue;
            this.classStack.add(clazzRelate.getName());
            int index = this.buildIndexDo(clazzRelate, false);
            if (maxIndex == null) {
                maxIndex = index;
                continue;
            }
            if (maxIndex >= index) continue;
            maxIndex = index;
        }
        if (maxIndex == null) {
            maxIndex = 0;
        }
        this.map.put(clazz.getName(), maxIndex + 1);
        return maxIndex + 1;
    }

    private List<Class<?>> findRelateClass(Class<?> clazz) {
        Field[] fields;
        ArrayList clazzList = new ArrayList();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Inject inject;
            if (!field.isAnnotationPresent(Inject.class) || (inject = field.getAnnotation(Inject.class)).value().contains("${") || clazz.equals(field.getType())) continue;
            clazzList.add(field.getType());
        }
        return clazzList;
    }

    private boolean isLoopRelate(Class<?> clazz, String topName) {
        if (this.classStack.contains(clazz.getName())) {
            return false;
        }
        this.classStack.add(clazz.getName());
        List<Class<?>> clazzList = this.findRelateClass(clazz);
        for (Class<?> clazzRelate : clazzList) {
            if (!clazzRelate.getName().equals(topName)) continue;
            this.classStack.add(clazzRelate.getName());
            return true;
        }
        for (Class<?> clazzRelate : clazzList) {
            if (!this.isLoopRelate(clazzRelate, topName)) continue;
            return true;
        }
        this.classStack.remove(clazz.getName());
        return false;
    }
}

