/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;

public class PropsLoader {
    private static PropsLoader global;

    public static PropsLoader global() {
        return global;
    }

    public static void globalSet(PropsLoader instance) {
        if (instance != null) {
            global = instance;
        }
    }

    public boolean isSupport(String suffix) {
        if (suffix == null) {
            return false;
        }
        return suffix.endsWith(".properties");
    }

    public Properties load(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        String fileName = url.toString();
        if (fileName.endsWith(".properties")) {
            if (Solon.app() != null && Solon.cfg().isDebugMode()) {
                LogUtil.global().trace(fileName);
            }
            Properties tmp = new Properties();
            tmp.load(new InputStreamReader(url.openStream(), Solon.encoding()));
            return tmp;
        }
        throw new IllegalStateException("This profile is not supported: " + fileName);
    }

    public Properties build(String txt) throws IOException {
        int idx1 = txt.indexOf("=");
        int idx2 = txt.indexOf(":");
        if (idx1 > 0 && (idx1 < idx2 || idx2 < 0)) {
            Properties tmp = new Properties();
            tmp.load(new StringReader(txt));
            return tmp;
        }
        return new Properties();
    }

    static {
        PropsLoader tmp = (PropsLoader)ClassUtil.newInstance("org.noear.solon.extend.impl.PropsLoaderExt");
        global = tmp == null ? new PropsLoader() : tmp;
    }
}

