/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.noear.solon.Utils;
import org.noear.solon.annotation.PropertySource;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.PropsConverter;

public class Props
extends Properties {
    private ClassLoader classLoader;
    private Set<BiConsumer<String, String>> _changeEvent = new HashSet<BiConsumer<String, String>>();

    public Props() {
    }

    public Props(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Props(Properties defaults) {
        super(defaults);
    }

    public Props(Map<String, String> data) {
        this.putAll(data);
    }

    @Override
    public synchronized int size() {
        if (this.defaults == null) {
            return super.size();
        }
        return super.size() + this.defaults.size();
    }

    public String get(String key) {
        return this.getProperty(key);
    }

    public String getByExpr(String expr) {
        return this.getByExpr(expr, null);
    }

    protected String getByExpr(String expr, Properties props) {
        String name = expr;
        if (name.startsWith("${") && name.endsWith("}")) {
            name = expr.substring(2, name.length() - 1);
        }
        String def = null;
        int defIdx = name.indexOf(":");
        if (defIdx > 0) {
            def = name.length() > defIdx + 1 ? name.substring(defIdx + 1).trim() : "";
            name = name.substring(0, defIdx).trim();
        }
        String val = null;
        if (props != null) {
            val = props.getProperty(name);
        }
        if (val == null && (val = this.get(name)) == null && Character.isUpperCase(name.charAt(0))) {
            val = System.getenv(name);
        }
        if (val == null) {
            return def;
        }
        return val;
    }

    public String getByParse(String tml) {
        return this.getByParse(tml, null);
    }

    protected String getByParse(String tml, Properties props) {
        if (Utils.isEmpty(tml)) {
            return tml;
        }
        int start = 0;
        int end = 0;
        while ((start = tml.indexOf("${", start)) >= 0) {
            end = tml.indexOf("}", start);
            if (end < 0) {
                throw new IllegalStateException("Invalid template expression: " + tml);
            }
            String name = tml.substring(start + 2, end);
            String value = this.getByExpr(name, props);
            if (value == null) {
                value = "";
            }
            tml = tml.substring(0, start) + value + tml.substring(end + 1);
            start += value.length();
        }
        return tml;
    }

    public String get(String key, String def) {
        return this.getProperty(key, def);
    }

    public boolean getBool(String key, boolean def) {
        return this.getOrDef(key, def, Boolean::parseBoolean);
    }

    public int getInt(String key, int def) {
        return this.getOrDef(key, def, Integer::parseInt);
    }

    public long getLong(String key, long def) {
        return this.getOrDef(key, def, Long::parseLong);
    }

    public Double getDouble(String key, double def) {
        return this.getOrDef(key, def, Double::parseDouble);
    }

    private <T> T getOrDef(String key, T def, Function<String, T> convert) {
        String temp = this.get(key);
        if (Utils.isEmpty(temp)) {
            return def;
        }
        return convert.apply(temp);
    }

    public <T> T getBean(String keyStarts, Class<T> clz) {
        Props props = this.getProp(keyStarts);
        return PropsConverter.global().convert(props, clz);
    }

    public <T> T getBean(Class<T> clz) {
        return PropsConverter.global().convert(this, clz);
    }

    public Props getProp(String keyStarts) {
        if (Utils.isEmpty(keyStarts)) {
            return this;
        }
        Props prop = new Props();
        this.doFind(keyStarts + ".", (key, val) -> {
            prop.put(key, val);
            if (key.contains("-")) {
                String camelKey = this.buildCamelKey((String)key);
                prop.put(camelKey, val);
            }
        });
        if (prop.size() == 0) {
            this.doFind(keyStarts + "[", (k, v) -> prop.put("[" + k, v));
        }
        return prop;
    }

    public Map<String, Props> getGroupedProp(String keyStarts) {
        Props rootProps = this.getProp(keyStarts);
        HashSet<String> groups = new HashSet<String>();
        for (Object key : rootProps.keySet()) {
            if (!(key instanceof String)) continue;
            groups.add(((String)key).split("\\.")[0]);
        }
        HashMap<String, Props> groupProps = new HashMap<String, Props>();
        for (String group : groups) {
            Props tmp = rootProps.getProp(group);
            groupProps.put(group, tmp);
        }
        return groupProps;
    }

    public Props getPropByExpr(String expr) {
        String name = expr;
        if (name.startsWith("${") && name.endsWith("}")) {
            name = expr.substring(2, name.length() - 1);
        }
        return this.getProp(name);
    }

    public NvMap getXmap(String keyStarts) {
        NvMap map = new NvMap();
        this.doFind(keyStarts + ".", map::put);
        return map;
    }

    public List<String> getList(String keyStarts) {
        TreeMap sortMap = new TreeMap();
        this.doFind(keyStarts + "[", (k, v) -> sortMap.put(k, v));
        return new ArrayList<String>(sortMap.values());
    }

    private void doFind(String keyStarts, BiConsumer<String, String> setFun) {
        String key2 = keyStarts;
        int idx2 = key2.length();
        this.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String keyStr;
            if (k instanceof String && v instanceof String && (keyStr = (String)k).startsWith(key2)) {
                String key = keyStr.substring(idx2);
                setFun.accept(key, (String)v);
                if (key.contains("-")) {
                    String camelKey = this.buildCamelKey(key);
                    setFun.accept(camelKey, (String)v);
                }
            }
        }));
    }

    @Override
    public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
        if (this.defaults == null) {
            super.forEach(action);
        } else {
            this.defaults.forEach(action);
            super.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (!this.defaults.containsKey(k)) {
                    action.accept(k, v);
                }
            }));
        }
    }

    public void onChange(BiConsumer<String, String> event) {
        this._changeEvent.add(event);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object obj = super.put(key, value);
        if (key instanceof String && value instanceof String) {
            this._changeEvent.forEach((? super T event) -> event.accept((String)key, (String)value));
        }
        return obj;
    }

    public synchronized void putIfNotNull(Object key, Object value) {
        if (key != null && value != null) {
            this.put(key, value);
        }
    }

    public void loadAdd(String url) {
        if (this.classLoader == null) {
            this.loadAdd(Utils.getResource(url));
        } else {
            this.loadAdd(Utils.getResource(this.classLoader, url));
        }
    }

    public void loadAdd(PropertySource propertySource) {
        if (propertySource == null) {
            return;
        }
        for (String url : propertySource.value()) {
            if (url.startsWith("classpath:")) {
                this.loadAdd(url.substring("classpath:".length()));
                continue;
            }
            try {
                this.loadAdd(new File(url).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void loadAdd(URL url) {
        if (url != null) {
            Properties props = Utils.loadProperties(url);
            this.loadAdd(props);
        }
    }

    public void loadAdd(Properties props) {
        this.loadAddDo(props, false, false);
    }

    public void loadAddIfAbsent(String url) {
        if (this.classLoader == null) {
            this.loadAddIfAbsent(Utils.getResource(url));
        } else {
            this.loadAddIfAbsent(Utils.getResource(this.classLoader, url));
        }
    }

    public void loadAddIfAbsent(URL url) {
        if (url != null) {
            Properties props = Utils.loadProperties(url);
            this.loadAddIfAbsent(props);
        }
    }

    public void loadAddIfAbsent(Properties props) {
        this.loadAddDo(props, false, true);
    }

    protected void loadAddDo(Properties props, boolean toSystem, boolean addIfAbsent) {
        if (props != null) {
            for (Map.Entry<Object, Object> kv : props.entrySet()) {
                String key;
                Object k1 = kv.getKey();
                Object v1 = kv.getValue();
                if (addIfAbsent && this.containsKey(k1) || !(k1 instanceof String) || Utils.isEmpty(key = (String)k1)) continue;
                if (v1 instanceof String) {
                    v1 = this.getByParse((String)v1, props);
                }
                if (v1 == null) continue;
                if (toSystem) {
                    System.getProperties().put(k1, v1);
                }
                this.put(k1, v1);
                if (!key.contains("-")) continue;
                String camelKey = this.buildCamelKey(key);
                this.put(camelKey, v1);
            }
        }
    }

    private String buildCamelKey(String key) {
        String[] ss = key.split("-");
        StringBuilder sb = new StringBuilder(key.length());
        sb.append(ss[0]);
        for (int i = 1; i < ss.length; ++i) {
            if (ss[i].length() > 1) {
                sb.append(ss[i].substring(0, 1).toUpperCase()).append(ss[i].substring(1));
                continue;
            }
            sb.append(ss[i].toUpperCase());
        }
        return sb.toString();
    }
}

