/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.noear.solon.Utils;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.util.ScanUtil;

public class ResourceUtil {
    public static Collection<Class<?>> scanClasses(String clzExpr) {
        return ResourceUtil.scanClasses(JarClassLoader.global(), clzExpr);
    }

    public static Collection<Class<?>> scanClasses(ClassLoader classLoader, String clzExpr) {
        ArrayList clzList = new ArrayList();
        if (clzExpr.indexOf("*") < 0) {
            String className = clzExpr.endsWith(".class") ? clzExpr.substring(0, clzExpr.length() - 6) : clzExpr;
            Class<?> clz = Utils.loadClass(classLoader, className);
            if (clz != null) {
                clzList.add(clz);
            }
            return clzList;
        }
        if (!clzExpr.endsWith(".class")) {
            clzExpr = clzExpr + ".class";
        }
        clzExpr = clzExpr.replace(".", "/");
        clzExpr = clzExpr.replace("/class", ".class");
        ResourceUtil.scanResources(classLoader, clzExpr).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class<?> clz = Utils.loadClass(classLoader, className = className.replace("/", "."));
            if (clz != null) {
                clzList.add(clz);
            }
        });
        return clzList;
    }

    public static Collection<String> scanResources(String resExpr) {
        return ResourceUtil.scanResources(JarClassLoader.global(), resExpr);
    }

    public static Collection<String> scanResources(ClassLoader classLoader, String resExpr) {
        ArrayList<String> paths = new ArrayList<String>();
        if (resExpr.startsWith("classpath:")) {
            resExpr = resExpr.substring("classpath:".length());
        }
        if (!resExpr.contains("/*")) {
            paths.add(resExpr);
            return paths;
        }
        int dirIdx = resExpr.indexOf("/*");
        if (dirIdx < 1) {
            throw new IllegalArgumentException("Expressions without a first-level directory are not supported: " + resExpr);
        }
        String dir = resExpr.substring(0, dirIdx);
        int sufIdx = resExpr.lastIndexOf(".");
        String suf = null;
        if (sufIdx > 0 && (suf = resExpr.substring(sufIdx)).contains("*")) {
            sufIdx = -1;
            suf = null;
        }
        int sufIdx2 = sufIdx;
        String suf2 = suf;
        String expr = resExpr.replaceAll("/\\*\\.", "/[^\\./]+\\.");
        expr = expr.replaceAll("/\\*\\*/", "(/[^/]*)*/");
        expr = expr.replaceAll("/\\*/", "/[^/]+/");
        Pattern pattern = Pattern.compile(expr);
        ScanUtil.scan(classLoader, dir, n -> {
            if (sufIdx2 > 0) {
                return n.endsWith(suf2);
            }
            return true;
        }).forEach(uri -> {
            if (pattern.matcher((CharSequence)uri).find()) {
                paths.add((String)uri);
            }
        });
        return paths;
    }
}

