/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Body;
import org.noear.solon.annotation.Cookie;
import org.noear.solon.annotation.Header;
import org.noear.solon.annotation.Param;
import org.noear.solon.annotation.PathVar;
import org.noear.solon.core.handle.Context;

public class ParamWrap {
    private final Parameter parameter;
    private String name;
    private String defaultValue;
    private boolean required;
    private boolean requireBody;
    private boolean isRequestHeader;
    private boolean isRequestCookie;
    private ParameterizedType genericType;

    public ParamWrap(Parameter parameter) {
        Type tmp;
        this.parameter = parameter;
        this.name = parameter.getName();
        if (!(this.resolveBody() || this.resolveParam() || this.resolvePathVar() || this.resolveHeader())) {
            this.resolveCookie();
        }
        this.genericType = (tmp = parameter.getParameterizedType()) instanceof ParameterizedType ? (ParameterizedType)tmp : null;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public String getName() {
        return this.name;
    }

    public String getValue(Context ctx) {
        if (this.isRequestHeader) {
            return ctx.header(this.getName());
        }
        if (this.isRequestCookie) {
            return ctx.cookie(this.getName());
        }
        return ctx.param(this.getName());
    }

    public ParameterizedType getGenericType() {
        return this.genericType;
    }

    public Class<?> getType() {
        return this.parameter.getType();
    }

    public boolean required() {
        return this.required;
    }

    public boolean requireBody() {
        return this.requireBody;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    private boolean resolveBody() {
        Body bodyAnno = this.parameter.getAnnotation(Body.class);
        if (bodyAnno == null) {
            return false;
        }
        this.requireBody = true;
        return true;
    }

    private boolean resolveParam() {
        Param paramAnno = this.parameter.getAnnotation(Param.class);
        if (paramAnno == null) {
            return false;
        }
        String name2 = Utils.annoAlias(paramAnno.value(), paramAnno.name());
        if (Utils.isNotEmpty(name2)) {
            this.name = name2;
        }
        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(paramAnno.defaultValue())) {
            this.defaultValue = paramAnno.defaultValue();
        }
        this.required = paramAnno.required();
        return true;
    }

    private boolean resolvePathVar() {
        PathVar paramAnno = this.parameter.getAnnotation(PathVar.class);
        if (paramAnno == null) {
            return false;
        }
        String name2 = Utils.annoAlias(paramAnno.value(), paramAnno.name());
        if (Utils.isNotEmpty(name2)) {
            this.name = name2;
        }
        this.required = true;
        return true;
    }

    private boolean resolveHeader() {
        Header headerAnno = this.parameter.getAnnotation(Header.class);
        if (headerAnno == null) {
            return false;
        }
        String name2 = Utils.annoAlias(headerAnno.value(), headerAnno.name());
        if (Utils.isNotEmpty(name2)) {
            this.name = name2;
        }
        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(headerAnno.defaultValue())) {
            this.defaultValue = headerAnno.defaultValue();
        }
        this.required = headerAnno.required();
        this.isRequestHeader = true;
        return true;
    }

    private boolean resolveCookie() {
        Cookie cookieAnno = this.parameter.getAnnotation(Cookie.class);
        if (cookieAnno == null) {
            return false;
        }
        String name2 = Utils.annoAlias(cookieAnno.value(), cookieAnno.name());
        if (Utils.isNotEmpty(name2)) {
            this.name = name2;
        }
        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(cookieAnno.defaultValue())) {
            this.defaultValue = cookieAnno.defaultValue();
        }
        this.required = cookieAnno.required();
        this.isRequestCookie = true;
        return true;
    }
}

