/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.lang.reflect.Method;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.handle.ActionExecutor;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.wrap.MethodWrap;

public class MethodHandler
implements Handler {
    private final BeanWrap bw;
    private final MethodWrap mw;
    private final boolean allowResult;

    public MethodHandler(BeanWrap beanWrap, Method method, boolean allowResult) {
        this.bw = beanWrap;
        this.mw = beanWrap.context().methodGet(method);
        this.allowResult = allowResult;
    }

    public MethodWrap method() {
        return this.mw;
    }

    @Override
    public void handle(Context c) throws Throwable {
        Object tmp = this.execute(c, this.bw.get());
        if (this.allowResult) {
            c.result = tmp;
        }
    }

    public Object execute(Context c, Object obj) throws Throwable {
        String ct = c.contentType();
        if (ct != null && this.mw.getParamWraps().length > 0) {
            for (ActionExecutor me : Bridge.actionExecutors()) {
                if (!me.matched(c, ct)) continue;
                return me.execute(c, obj, this.mw);
            }
        }
        return Bridge.actionExecutorDef().execute(c, obj, this.mw);
    }
}

