/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.File;
import java.util.Comparator;
import java.util.List;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.PluginEntity;

public class PluginPackage {
    private final File file;
    private final JarClassLoader classLoader;
    private final List<PluginEntity> plugins;

    public PluginPackage(File file, JarClassLoader classLoader, List<PluginEntity> plugins) {
        if (plugins.size() > 0) {
            plugins.sort(Comparator.comparingInt(PluginEntity::getPriority).reversed());
        }
        this.file = file;
        this.plugins = plugins;
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public File getFile() {
        return this.file;
    }

    public void start() {
        for (PluginEntity p1 : this.plugins) {
            p1.start();
        }
    }

    public void prestop() {
        for (PluginEntity p1 : this.plugins) {
            p1.prestop();
        }
    }

    public void stop() {
        for (PluginEntity p1 : this.plugins) {
            p1.stop();
        }
    }
}

