/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Note;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.NdMap;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.ContextUtil;
import org.noear.solon.core.handle.DownloadedFile;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IpUtil;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.core.wrap.ClassWrap;

public abstract class Context {
    private Locale locale;
    private boolean handled;
    private boolean rendered;
    private String realIp;
    private String protocolAsUpper;
    private String pathNew;
    private String pathAsUpper;
    private String accept;
    private String body;
    private String bodyNew;
    private SessionState sessionState;
    protected Charset charset = StandardCharsets.UTF_8;
    private String contentTypeNew;
    private NdMap attrMap = null;
    private boolean _remoting;
    @Note(value="\u5904\u7406\u7ed3\u679c")
    public Object result;
    @Note(value="\u5904\u7406\u9519\u8bef")
    public Throwable errors;

    public static Context current() {
        return ContextUtil.current();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Note(value="\u8bbe\u7f6e\u5904\u7406\u72b6\u6001")
    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    @Note(value="\u83b7\u53d6\u5904\u7406\u72b6\u6001")
    public boolean getHandled() {
        return this.handled;
    }

    @Note(value="\u8bbe\u7f6e\u6e32\u67d3\u72b6\u6001")
    public void setRendered(boolean rendered) {
        this.rendered = rendered;
    }

    @Note(value="\u83b7\u53d6\u6e32\u67d3\u72b6\u6001")
    public boolean getRendered() {
        return this.rendered;
    }

    @Note(value="\u83b7\u53d6\u8bf7\u6c42\u5bf9\u8c61")
    public abstract Object request();

    @Note(value="\u83b7\u53d6\u8fdc\u7a0bIP")
    public abstract String ip();

    @Note(value="\u83b7\u53d6\u5ba2\u6237\u7aef\u771f\u5b9eIP")
    public String realIp() {
        if (this.realIp == null) {
            this.realIp = IpUtil.getIp(this);
        }
        return this.realIp;
    }

    public boolean isMultipart() {
        String temp = this.contentType();
        if (temp == null) {
            return false;
        }
        return temp.toLowerCase().contains("multipart/");
    }

    public boolean isMultipartFormData() {
        String temp = this.contentType();
        if (temp == null) {
            return false;
        }
        return temp.toLowerCase().contains("multipart/form-data");
    }

    @Note(value="\u83b7\u53d6\u8bf7\u6c42\u65b9\u5f0f")
    public abstract String method();

    @Note(value="\u83b7\u53d6\u8bf7\u6c42\u534f\u8bae")
    public abstract String protocol();

    public String protocolAsUpper() {
        if (this.protocolAsUpper == null) {
            this.protocolAsUpper = this.protocol().toUpperCase();
        }
        return this.protocolAsUpper;
    }

    public abstract URI uri();

    public abstract String path();

    public void pathNew(String pathNew) {
        this.pathNew = pathNew;
    }

    public String pathNew() {
        if (this.pathNew == null) {
            return this.path();
        }
        return this.pathNew;
    }

    public NvMap pathMap(String expr) {
        return PathUtil.pathVarMap(this.path(), expr);
    }

    public String pathAsUpper() {
        if (this.pathAsUpper == null) {
            this.pathAsUpper = this.path().toUpperCase();
        }
        return this.pathAsUpper;
    }

    public String userAgent() {
        return this.header("User-Agent");
    }

    public abstract String url();

    public abstract long contentLength();

    public abstract String contentType();

    public abstract String queryString();

    public String accept() {
        if (this.accept == null) {
            this.accept = this.header("Accept", "");
        }
        return this.accept;
    }

    public String body() throws IOException {
        return this.body(null);
    }

    public String body(String charset) throws IOException {
        if (this.body == null) {
            try (InputStream ins = this.bodyAsStream();){
                this.body = Utils.transferToString(ins, charset);
            }
        }
        return this.body;
    }

    public String bodyNew() throws IOException {
        if (this.bodyNew == null) {
            return this.body();
        }
        return this.bodyNew;
    }

    public void bodyNew(String bodyNew) {
        this.bodyNew = bodyNew;
    }

    public byte[] bodyAsBytes() throws IOException {
        try (InputStream ins = this.bodyAsStream();){
            if (ins == null) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayOutputStream outs = new ByteArrayOutputStream();
            int len = 0;
            byte[] buf = new byte[512];
            while ((len = ins.read(buf)) != -1) {
                outs.write(buf, 0, len);
            }
            byte[] byArray = outs.toByteArray();
            return byArray;
        }
    }

    public abstract InputStream bodyAsStream() throws IOException;

    public abstract String[] paramValues(String var1);

    public abstract String param(String var1);

    public abstract String param(String var1, String var2);

    public int paramAsInt(String name) {
        return this.paramAsInt(name, 0);
    }

    public int paramAsInt(String name, int def) {
        return Integer.parseInt(this.param(name, String.valueOf(def)));
    }

    public long paramAsLong(String name) {
        return this.paramAsLong(name, 0L);
    }

    public long paramAsLong(String name, long def) {
        return Long.parseLong(this.param(name, String.valueOf(def)));
    }

    public double paramAsDouble(String name) {
        return this.paramAsDouble(name, 0.0);
    }

    public double paramAsDouble(String name, double def) {
        return Double.parseDouble(this.param(name, String.valueOf(def)));
    }

    public BigDecimal paramAsDecimal(String name) {
        return this.paramAsDecimal(name, BigDecimal.ZERO);
    }

    public BigDecimal paramAsDecimal(String name, BigDecimal def) {
        String tmp = this.param(name);
        if (Utils.isEmpty(tmp)) {
            return def;
        }
        return new BigDecimal(tmp);
    }

    public <T> T paramAsBean(Class<T> type) {
        return ClassWrap.get(type).newBy(this::param, this);
    }

    public abstract NvMap paramMap();

    public void paramSet(String name, String val) {
        this.paramMap().put(name, val);
        this.paramsAdd(name, val);
    }

    public abstract Map<String, List<String>> paramsMap();

    public void paramsAdd(String name, String val) {
        if (this.paramsMap() != null) {
            List<String> ary = this.paramsMap().get(name);
            if (ary == null) {
                ary = new ArrayList<String>();
                this.paramsMap().put(name, ary);
            }
            ary.add(val);
        }
    }

    public abstract List<UploadedFile> files(String var1) throws Exception;

    public UploadedFile file(String name) throws Exception {
        return Utils.firstOrNull(this.files(name));
    }

    public String cookie(String name) {
        return (String)this.cookieMap().get(name);
    }

    public String cookie(String name, String def) {
        return this.cookieMap().getOrDefault(name, def);
    }

    public abstract NvMap cookieMap();

    public String header(String name) {
        return (String)this.headerMap().get(name);
    }

    public String header(String name, String def) {
        return this.headerMap().getOrDefault(name, def);
    }

    public abstract NvMap headerMap();

    protected void sessionStateInit(SessionState sessionState) {
        if (this.sessionState().replaceable()) {
            this.sessionState = sessionState;
        }
    }

    public SessionState sessionState() {
        if (this.sessionState == null) {
            this.sessionState = Bridge.sessionState(this);
        }
        return this.sessionState;
    }

    public final String sessionId() {
        return this.sessionState().sessionId();
    }

    public final Object session(String name) {
        return this.sessionState().sessionGet(name);
    }

    @Note(value="\u6cdb\u578b\u8f6c\u6362\uff0c\u5b58\u5728\u8f6c\u6362\u98ce\u9669")
    public final <T> T session(String name, T def) {
        Object tmp = this.session(name);
        if (tmp == null) {
            return def;
        }
        return (T)tmp;
    }

    public final int sessionAsInt(String name) {
        return this.sessionAsInt(name, 0);
    }

    public final int sessionAsInt(String name, int def) {
        String str;
        Object tmp = this.session(name);
        if (tmp == null) {
            return def;
        }
        if (tmp instanceof Number) {
            return ((Number)tmp).intValue();
        }
        if (tmp instanceof String && (str = (String)tmp).length() > 0) {
            return Integer.parseInt(str);
        }
        return def;
    }

    public final long sessionAsLong(String name) {
        return this.sessionAsLong(name, 0L);
    }

    public final long sessionAsLong(String name, long def) {
        String str;
        Object tmp = this.session(name);
        if (tmp == null) {
            return def;
        }
        if (tmp instanceof Number) {
            return ((Number)tmp).longValue();
        }
        if (tmp instanceof String && (str = (String)tmp).length() > 0) {
            return Long.parseLong(str);
        }
        return def;
    }

    public final double sessionAsDouble(String name) {
        return this.sessionAsDouble(name, 0.0);
    }

    public final double sessionAsDouble(String name, double def) {
        String str;
        Object tmp = this.session(name);
        if (tmp == null) {
            return def;
        }
        if (tmp instanceof Number) {
            return ((Number)tmp).doubleValue();
        }
        if (tmp instanceof String && (str = (String)tmp).length() > 0) {
            return Double.parseDouble(str);
        }
        return def;
    }

    public final void sessionSet(String name, Object val) {
        this.sessionState().sessionSet(name, val);
    }

    public final void sessionClear() {
        this.sessionState().sessionClear();
    }

    public abstract Object response();

    public void charset(String charset) {
        this.charset = Charset.forName(charset);
    }

    public void contentType(String contentType) {
        this.contentTypeDoSet(contentType);
        if (!"text/plain;charset=UTF-8".equals(contentType)) {
            this.contentTypeNew = contentType;
        }
    }

    public String contentTypeNew() {
        return this.contentTypeNew;
    }

    protected abstract void contentTypeDoSet(String var1);

    public abstract void output(byte[] var1);

    public abstract void output(InputStream var1);

    public abstract OutputStream outputStream() throws IOException;

    public void output(String str) {
        if (str != null) {
            this.attrSet("output", str);
            this.output(str.getBytes(this.charset));
        }
    }

    public void output(Throwable ex) {
        this.output(Utils.getFullStackTrace(ex));
    }

    public void outputAsJson(String json) {
        this.contentType("application/json;charset=utf-8");
        this.output(json);
    }

    public void outputAsHtml(String html) {
        this.contentType("text/html;charset=utf-8");
        if (!html.startsWith("<")) {
            StringBuilder sb = new StringBuilder();
            sb.append("<!doctype html>");
            sb.append("<html>");
            sb.append(html);
            sb.append("</html>");
            this.output(sb.toString());
        } else {
            this.output(html);
        }
    }

    public void outputAsFile(DownloadedFile file) throws IOException {
        if (Utils.isNotEmpty(file.contentType)) {
            this.contentType(file.contentType);
        }
        if (Utils.isNotEmpty(file.name)) {
            String fileName = URLEncoder.encode(file.name, Solon.cfg().fileEncoding());
            this.headerSet("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        }
        Utils.transferTo(file.content, this.outputStream());
    }

    public void outputAsFile(File file) throws IOException {
        if (Utils.isNotEmpty(file.getName())) {
            String fileName = URLEncoder.encode(file.getName(), Solon.cfg().fileEncoding());
            this.headerSet("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        }
        try (FileInputStream ins = new FileInputStream(file);){
            Utils.transferTo(ins, this.outputStream());
        }
    }

    public abstract void headerSet(String var1, String var2);

    public abstract void headerAdd(String var1, String var2);

    public void cookieSet(String name, String val) {
        this.cookieSet(name, val, null, -1);
    }

    public void cookieSet(String name, String val, int maxAge) {
        this.cookieSet(name, val, null, maxAge);
    }

    public void cookieSet(String name, String val, String domain, int maxAge) {
        this.cookieSet(name, val, domain, "/", maxAge);
    }

    public abstract void cookieSet(String var1, String var2, String var3, String var4, int var5);

    public void cookieRemove(String name) {
        this.cookieSet(name, "", 0);
    }

    @Note(value="\u8df3\u8f6c\u5730\u5740")
    public abstract void redirect(String var1);

    @Note(value="\u8df3\u8f6c\u5730\u5740")
    public abstract void redirect(String var1, int var2);

    @Note(value="\u8f6c\u53d1")
    public void forward(String pathNew) {
        this.pathNew(pathNew);
        Solon.global().tryHandle(this);
        this.setHandled(true);
        this.setRendered(true);
    }

    @Note(value="\u83b7\u53d6\u8f93\u51fa\u72b6\u6001")
    public abstract int status();

    @Note(value="\u8bbe\u7f6e\u8f93\u51fa\u72b6\u6001")
    public void status(int status) {
        this.statusDoSet(status);
    }

    @Deprecated
    public void statusSet(int status) {
        this.statusDoSet(status);
    }

    protected abstract void statusDoSet(int var1);

    @Note(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u7279\u6027\u5e76\u8f6c\u4e3aMap")
    public Map<String, Object> attrMap() {
        if (this.attrMap == null) {
            this.attrMap = new NdMap();
        }
        return this.attrMap;
    }

    public <T> T attr(String name, T def) {
        Object val = this.attrMap().get(name);
        if (val == null) {
            return def;
        }
        return (T)val;
    }

    public <T> T attr(String name) {
        return (T)this.attrMap().get(name);
    }

    public void attrSet(String name, Object val) {
        this.attrMap().put(name, val);
    }

    public void attrSet(Map<String, Object> map) {
        this.attrMap().putAll(map);
    }

    public void attrClear() {
        this.attrMap().clear();
    }

    public final void render(Object obj) throws Throwable {
        this.setRendered(true);
        RenderManager.global.render(obj, this);
    }

    public final void render(String view, Map<String, ?> data) throws Throwable {
        this.render(new ModelAndView(view, data));
    }

    public final String renderAndReturn(ModelAndView modelAndView) throws Throwable {
        return RenderManager.global.renderAndReturn(modelAndView, this);
    }

    @Note(value="\u662f\u5426\u4e3a\u8fdc\u7a0b\u8c03\u7528")
    public boolean remoting() {
        return this._remoting;
    }

    public void remotingSet(boolean remoting) {
        this._remoting = remoting;
    }

    @Note(value="\u51b2\u5237")
    public abstract void flush() throws IOException;

    @Note(value="\u63d0\u4ea4\u54cd\u5e94")
    protected void commit() throws IOException {
    }

    @Note(value="\u5173\u95ed\u54cd\u5e94")
    public void close() throws IOException {
    }

    @Note(value="\u63a7\u5236\u5668?")
    public Object controller() {
        return this.attr("controller");
    }

    @Note(value="\u52a8\u4f5c?")
    public Action action() {
        return (Action)this.attr("action");
    }
}

