/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericUtil {
    private static final Map<Type, Map<String, Type>> genericInfoCached = new HashMap<Type, Map<String, Type>>();

    public static Class<?>[] resolveTypeArguments(Class<?> clazz, Class<?> genericIfc) {
        for (Type type0 : clazz.getGenericInterfaces()) {
            ParameterizedType type;
            Class rawType;
            if (!(type0 instanceof ParameterizedType) || (rawType = (Class)(type = (ParameterizedType)type0).getRawType()) != genericIfc && !GenericUtil.getGenericInterfaces(rawType).contains(genericIfc)) continue;
            return (Class[])Arrays.stream(type.getActualTypeArguments()).map(item -> (Class)item).toArray(Class[]::new);
        }
        return null;
    }

    private static List<Class<?>> getGenericInterfaces(Class<?> clazz) {
        return GenericUtil.getGenericInterfaces(clazz, new ArrayList());
    }

    private static List<Class<?>> getGenericInterfaces(Class<?> clazz, List<Class<?>> classes) {
        Type[] interfaces;
        for (Type type : interfaces = clazz.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType)) continue;
            Class aClass = (Class)((ParameterizedType)type).getRawType();
            classes.add(aClass);
            for (Type type0 : aClass.getGenericInterfaces()) {
                if (!(type0 instanceof ParameterizedType)) continue;
                GenericUtil.getGenericInterfaces((Class)((ParameterizedType)type0).getRawType(), classes);
            }
        }
        return classes;
    }

    public static ParameterizedType toParameterizedType(Type type) {
        ParameterizedType result = null;
        if (type instanceof ParameterizedType) {
            result = (ParameterizedType)type;
        } else if (type instanceof Class) {
            Type[] genericInterfaces;
            Class clazz = (Class)type;
            Type genericSuper = clazz.getGenericSuperclass();
            if ((null == genericSuper || Object.class.equals((Object)genericSuper)) && (genericInterfaces = clazz.getGenericInterfaces()) != null && genericInterfaces.length > 0) {
                genericSuper = genericInterfaces[0];
            }
            result = GenericUtil.toParameterizedType(genericSuper);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Type> getGenericInfo(Type type) {
        Map<String, Type> tmp = genericInfoCached.get(type);
        if (tmp == null) {
            Type type2 = type;
            synchronized (type2) {
                tmp = genericInfoCached.get(type);
                if (tmp == null) {
                    tmp = GenericUtil.createTypeGenericMap(type);
                    genericInfoCached.put(type, tmp);
                }
            }
        }
        return tmp;
    }

    private static Map<String, Type> createTypeGenericMap(Type type) {
        ParameterizedType parameterizedType;
        HashMap<String, Type> typeMap = new HashMap<String, Type>();
        while (null != type && null != (parameterizedType = GenericUtil.toParameterizedType(type))) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                Type value = typeArguments[i];
                if (value instanceof TypeVariable) continue;
                typeMap.put(typeParameters[i].getTypeName(), value);
            }
            type = rawType;
        }
        return typeMap;
    }
}

