/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.annotation.Note;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.handle.ActionExecutor;
import org.noear.solon.core.handle.ActionExecutorDefault;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.handle.SessionStateDefault;
import org.noear.solon.core.handle.SessionStateFactory;

public class Bridge {
    private static SessionStateFactory _sessionStateFactory = ctx -> new SessionStateDefault();
    private static boolean sessionStateUpdated;
    private static LoadBalance.Factory _upstreamFactory;
    private static ActionExecutor _actionExecutorDef;
    private static Set<ActionExecutor> _actionExecutors;

    public static SessionStateFactory sessionStateFactory() {
        return _sessionStateFactory;
    }

    @Note(value="\u8bbe\u7f6eSession\u72b6\u6001\u7ba1\u7406\u5668")
    public static void sessionStateFactorySet(SessionStateFactory ssf) {
        if (ssf != null) {
            _sessionStateFactory = ssf;
            if (!sessionStateUpdated) {
                sessionStateUpdated = true;
                Solon.global().before("**", MethodType.HTTP, c -> c.sessionState().sessionRefresh());
            }
        }
    }

    @Note(value="\u83b7\u53d6Session\u72b6\u6001\u7ba1\u7406\u5668")
    public static SessionState sessionState(Context ctx) {
        return _sessionStateFactory.create(ctx);
    }

    @Note(value="\u83b7\u53d6\u8d1f\u8f7d\u5de5\u5382")
    public static LoadBalance.Factory upstreamFactory() {
        return _upstreamFactory;
    }

    @Note(value="\u8bbe\u7f6e\u8d1f\u8f7d\u5de5\u5382")
    public static void upstreamFactorySet(LoadBalance.Factory uf) {
        if (uf != null) {
            _upstreamFactory = uf;
        }
    }

    @Note(value="\u83b7\u53d6\u9ed8\u8ba4\u7684Action\u6267\u884c\u5668")
    public static ActionExecutor actionExecutorDef() {
        return _actionExecutorDef;
    }

    @Note(value="\u8bbe\u7f6e\u9ed8\u8ba4\u7684Action\u6267\u884c\u5668")
    public static void actionExecutorDefSet(ActionExecutor ae) {
        if (ae != null) {
            _actionExecutorDef = ae;
        }
    }

    @Note(value="\u83b7\u53d6\u6240\u6709Action\u6267\u884c\u5668")
    public static Set<ActionExecutor> actionExecutors() {
        return Collections.unmodifiableSet(_actionExecutors);
    }

    @Note(value="\u6dfb\u52a0Action\u6267\u884c\u5668")
    public static void actionExecutorAdd(ActionExecutor e) {
        if (e != null) {
            _actionExecutors.add(e);
        }
    }

    static {
        _upstreamFactory = (g, s) -> null;
        _actionExecutorDef = new ActionExecutorDefault();
        _actionExecutors = new HashSet<ActionExecutor>();
    }
}

