/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.annotation.Around;
import org.noear.solon.core.Aop;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.InterceptorEntity;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.wrap.MethodHolder;
import org.noear.solon.core.wrap.ParamWrap;

public class MethodWrap
implements Interceptor,
MethodHolder {
    private static Map<Method, MethodWrap> cached = new HashMap<Method, MethodWrap>();
    private final Class<?> entityClz;
    private final Method method;
    private final ParamWrap[] parameters;
    private final Annotation[] annotations;
    private final List<InterceptorEntity> arounds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodWrap get(Method method) {
        MethodWrap mw = cached.get(method);
        if (mw == null) {
            Method method2 = method;
            synchronized (method2) {
                mw = cached.get(method);
                if (mw == null) {
                    mw = new MethodWrap(method);
                    cached.put(method, mw);
                }
            }
        }
        return mw;
    }

    protected MethodWrap(Method m) {
        InterceptorEntity ie;
        this.entityClz = m.getDeclaringClass();
        this.method = m;
        this.parameters = this.paramsWrap(m.getParameters());
        this.annotations = m.getAnnotations();
        this.arounds = new ArrayList<InterceptorEntity>();
        for (Annotation anno : this.entityClz.getAnnotations()) {
            if (anno instanceof Around) {
                this.doAroundAdd((Around)anno);
                continue;
            }
            ie = Aop.context().beanAroundGet(anno.annotationType());
            if (ie != null) {
                this.doAroundAdd(ie);
                continue;
            }
            this.doAroundAdd(anno.annotationType().getAnnotation(Around.class));
        }
        for (Annotation anno : this.annotations) {
            if (anno instanceof Around) {
                this.doAroundAdd((Around)anno);
                continue;
            }
            ie = Aop.context().beanAroundGet(anno.annotationType());
            if (ie != null) {
                this.doAroundAdd(ie);
                continue;
            }
            this.doAroundAdd(anno.annotationType().getAnnotation(Around.class));
        }
        if (this.arounds.size() > 0) {
            this.arounds.sort(Comparator.comparing(x -> x.index));
        }
        this.arounds.add(new InterceptorEntity(0, this));
    }

    private ParamWrap[] paramsWrap(Parameter[] pAry) {
        ParamWrap[] tmp = new ParamWrap[pAry.length];
        int len = pAry.length;
        for (int i = 0; i < len; ++i) {
            tmp[i] = new ParamWrap(pAry[i]);
        }
        return tmp;
    }

    private void doAroundAdd(Around a) {
        if (a != null) {
            this.arounds.add(new InterceptorEntity(a.index(), (Interceptor)Aop.getOrNew(a.value())));
        }
    }

    private void doAroundAdd(InterceptorEntity i) {
        if (i != null) {
            this.arounds.add(i);
        }
    }

    public String getName() {
        return this.method.getName();
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    @Override
    public ParamWrap[] getParamWraps() {
        return this.parameters;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return this.method.getAnnotation(type);
    }

    @Override
    public Object doIntercept(Invocation inv) throws Exception {
        return this.invoke(inv.target(), inv.args());
    }

    public Object invoke(Object obj, Object[] args) throws Exception {
        try {
            return this.method.invoke(obj, args);
        }
        catch (InvocationTargetException e) {
            Throwable ex = e.getTargetException();
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            throw (Exception)ex;
        }
    }

    public Object invokeByAspect(Object obj, Object[] args) throws Throwable {
        Invocation inv = new Invocation(obj, args, this, this.arounds);
        return inv.invoke();
    }
}

