/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.annotation.Init;
import org.noear.solon.annotation.Singleton;
import org.noear.solon.core.Aop;
import org.noear.solon.core.wrap.ClassWrap;

public class BeanWrap {
    private Class<?> clz;
    private Method clzInit;
    private boolean clzInitDelay;
    private Object raw;
    private boolean singleton;
    private boolean remoting;
    private String name;
    private String tag;
    private String[] attrs;
    private Map<String, String> attrMap;
    private boolean typed;
    private Proxy proxy;
    private final Annotation[] annotations;

    public BeanWrap(Class<?> clz) {
        this(clz, null);
    }

    public BeanWrap(Class<?> clz, Object raw) {
        this.clz = clz;
        Singleton ano = clz.getAnnotation(Singleton.class);
        this.singleton = ano == null || ano.value();
        this.annotations = clz.getAnnotations();
        this.tryBuildInit();
        this.raw = raw == null ? this._new() : raw;
    }

    public BeanWrap(Class<?> clz, Object raw, String[] attrs) {
        this(clz, raw);
        this.attrsSet(attrs);
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public void proxySet(Proxy proxy) {
        this.proxy = proxy;
        if (this.raw != null) {
            this.raw = proxy.getProxy(this.raw);
        }
    }

    public boolean singleton() {
        return this.singleton;
    }

    public void singletonSet(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean remoting() {
        return this.remoting;
    }

    public void remotingSet(boolean remoting) {
        this.remoting = remoting;
    }

    public Class<?> clz() {
        return this.clz;
    }

    public <T> T raw() {
        return (T)this.raw;
    }

    protected void rawSet(Object raw) {
        this.raw = raw;
    }

    public String name() {
        return this.name;
    }

    protected void nameSet(String name) {
        this.name = name;
    }

    public String tag() {
        return this.tag;
    }

    protected void tagSet(String tag) {
        this.tag = tag;
    }

    public String[] attrs() {
        return this.attrs;
    }

    protected void attrsSet(String[] attrs) {
        this.attrs = attrs;
    }

    public String attrGet(String name) {
        if (this.attrs == null) {
            return null;
        }
        if (this.attrMap == null) {
            this.attrMap = new HashMap<String, String>();
            for (String kv : this.attrs) {
                String[] ss = kv.split("=");
                if (ss.length != 2) continue;
                this.attrMap.put(ss[0], ss[1]);
            }
        }
        return this.attrMap.get(name);
    }

    public boolean typed() {
        return this.typed;
    }

    protected void typedSet(boolean typed) {
        this.typed = typed;
    }

    public Annotation[] annotations() {
        return this.annotations;
    }

    public <T extends Annotation> T annotationGet(Class<T> annClz) {
        return this.clz.getAnnotation(annClz);
    }

    public <T> T get() {
        if (this.singleton) {
            return (T)this.raw;
        }
        return (T)this._new();
    }

    public void init(Object bean) {
        Aop.inject(bean);
        if (this.clzInit != null) {
            if (this.clzInitDelay) {
                Aop.beanOnloaded(() -> this.initInvokeDo(bean));
            } else {
                this.initInvokeDo(bean);
            }
        }
    }

    protected void initInvokeDo(Object bean) {
        try {
            this.clzInit.invoke(bean, new Object[0]);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Object _new() {
        if (this.clz.isInterface()) {
            return this.raw;
        }
        try {
            Object bean = this.clz.newInstance();
            this.init(bean);
            if (this.proxy != null) {
                bean = this.proxy.getProxy(bean);
            }
            return bean;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Instantiation failure: " + this.clz.getTypeName(), ex);
        }
    }

    protected void tryBuildInit() {
        if (this.clzInit != null) {
            return;
        }
        if (this.clz.isInterface()) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(this.clz);
        for (Method m : clzWrap.getMethods()) {
            Init initAnno = m.getAnnotation(Init.class);
            if (initAnno == null) continue;
            if (m.getParameters().length != 0) break;
            this.clzInit = m;
            this.clzInitDelay = initAnno.delay();
            break;
        }
    }

    @FunctionalInterface
    public static interface Proxy {
        public Object getProxy(Object var1);
    }
}

