/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Param;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.DateUtil;

public class ConvertUtil {
    public static Object to(AnnotatedElement element, Class<?> type, String key, String val, Context ctx) throws ClassCastException {
        if (String.class == type) {
            return val;
        }
        if (val.length() == 0) {
            return null;
        }
        Object rst = ConvertUtil.tryTo(type, val);
        if (rst != null) {
            return rst;
        }
        if (Date.class == type && element != null) {
            Param xd = element.getAnnotation(Param.class);
            try {
                if (xd != null && !Utils.isEmpty(xd.format())) {
                    return new SimpleDateFormat(xd.format()).parse(val);
                }
                return DateUtil.parse(val);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (type.isArray()) {
            if (ctx == null) {
                return null;
            }
            String[] ary = ctx.paramValues(key);
            if (ary == null) {
                return null;
            }
            int len = ary.length;
            if (ConvertUtil.is(String[].class, type)) {
                return ary;
            }
            if (ConvertUtil.is(short[].class, type)) {
                short[] ary2 = new short[len];
                for (int i = 0; i < len; ++i) {
                    ary2[i] = Short.parseShort(ary[i]);
                }
                return ary2;
            }
            if (ConvertUtil.is(int[].class, type)) {
                int[] ary2 = new int[len];
                for (int i = 0; i < len; ++i) {
                    ary2[i] = Integer.parseInt(ary[i]);
                }
                return ary2;
            }
            if (ConvertUtil.is(long[].class, type)) {
                long[] ary2 = new long[len];
                for (int i = 0; i < len; ++i) {
                    ary2[i] = Long.parseLong(ary[i]);
                }
                return ary2;
            }
            if (ConvertUtil.is(float[].class, type)) {
                float[] ary2 = new float[len];
                for (int i = 0; i < len; ++i) {
                    ary2[i] = Float.parseFloat(ary[i]);
                }
                return ary2;
            }
            if (ConvertUtil.is(double[].class, type)) {
                double[] ary2 = new double[len];
                for (int i = 0; i < len; ++i) {
                    ary2[i] = Double.parseDouble(ary[i]);
                }
                return ary2;
            }
            if (ConvertUtil.is(Object[].class, type)) {
                Class<?> c = type.getComponentType();
                Object[] ary2 = (Object[])Array.newInstance(c, len);
                for (int i = 0; i < len; ++i) {
                    ary2[i] = ConvertUtil.tryTo(c, ary[i]);
                }
                return ary2;
            }
        }
        throw new ClassCastException("\u4e0d\u652f\u6301\u7c7b\u578b:" + type.getName());
    }

    public static Object to(Class<?> type, String val) throws ClassCastException {
        if (String.class == type) {
            return val;
        }
        if (val.length() == 0) {
            return null;
        }
        Object rst = ConvertUtil.tryTo(type, val);
        if (rst != null) {
            return rst;
        }
        if (Date.class == type) {
            try {
                return DateUtil.parse(val);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new ClassCastException("\u4e0d\u652f\u6301\u7c7b\u578b:" + type.getName());
    }

    public static Object tryTo(Class<?> type, String val) {
        if (Short.class == type || type == Short.TYPE) {
            return Short.parseShort(val);
        }
        if (Integer.class == type || type == Integer.TYPE) {
            return Integer.parseInt(val);
        }
        if (Long.class == type || type == Long.TYPE) {
            return Long.parseLong(val);
        }
        if (Double.class == type || type == Double.TYPE) {
            return Double.parseDouble(val);
        }
        if (Float.class == type || type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(val));
        }
        if (Boolean.class == type || type == Boolean.TYPE) {
            return Boolean.parseBoolean(val);
        }
        if (LocalDate.class == type) {
            return LocalDate.parse(val);
        }
        if (LocalTime.class == type) {
            return LocalTime.parse(val);
        }
        if (LocalDateTime.class == type) {
            return LocalDateTime.parse(val);
        }
        if (BigDecimal.class == type) {
            return new BigDecimal(val);
        }
        if (BigInteger.class == type) {
            return new BigInteger(val);
        }
        if (type.isEnum()) {
            return ConvertUtil.enumOf(type, val);
        }
        return null;
    }

    private static <T extends Enum<T>> T enumOf(Class<T> enumType, String name) {
        for (Enum each : (Enum[])enumType.getEnumConstants()) {
            if (each.name().compareToIgnoreCase(name) != 0) continue;
            return (T)each;
        }
        return null;
    }

    private static boolean is(Class<?> s, Class<?> t) {
        return s.isAssignableFrom(t);
    }
}

