/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.Collections;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Endpoint;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.message.Session;
import org.noear.solon.core.route.Router;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.route.RoutingDefault;
import org.noear.solon.core.route.RoutingTable;

public class RouterDefault
implements Router {
    private final RoutingTable<Handler>[] routesH = new RoutingTable[3];
    private final RoutingTable<Listener> routesL;

    public RouterDefault() {
        this.routesH[0] = new RoutingTable();
        this.routesH[1] = new RoutingTable();
        this.routesH[2] = new RoutingTable();
        this.routesL = new RoutingTable();
    }

    @Override
    public void add(String path, Endpoint endpoint, MethodType method, int index, Handler handler) {
        this.routesH[endpoint.code].add(new RoutingDefault<Handler>(path, method, index, handler));
    }

    @Override
    public List<Routing<Handler>> getAll(Endpoint endpoint) {
        return Collections.unmodifiableList(this.routesH[endpoint.code]);
    }

    @Override
    public Handler matchOne(Context ctx, Endpoint endpoint) {
        String pathNew = ctx.pathNew();
        MethodType method = MethodType.valueOf(ctx.method());
        return this.routesH[endpoint.code].matchOne(pathNew, method);
    }

    @Override
    public List<Handler> matchAll(Context ctx, Endpoint endpoint) {
        String pathNew = ctx.pathNew();
        MethodType method = MethodType.valueOf(ctx.method());
        return this.routesH[endpoint.code].matchAll(pathNew, method);
    }

    @Override
    public void add(String path, MethodType method, int index, Listener listener) {
        this.routesL.add(new RoutingDefault<Listener>(path, method, index, listener));
    }

    @Override
    public Listener matchOne(Session session) {
        String path = session.path();
        if (path == null) {
            return null;
        }
        return this.routesL.matchOne(path, session.method());
    }

    @Override
    public void clear() {
        this.routesH[0].clear();
        this.routesH[1].clear();
        this.routesH[2].clear();
        this.routesL.clear();
    }
}

