/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.noear.solon.Utils;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.event.EventBus;

public class ResourceScaner {
    public static Set<String> scan(String path, Predicate<String> filter) {
        return ResourceScaner.scan(JarClassLoader.global(), path, filter);
    }

    public static Set<String> scan(ClassLoader classLoader, String path, Predicate<String> filter) {
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        if (classLoader == null) {
            return urls;
        }
        try {
            Enumeration<URL> roots = Utils.getResources(classLoader, path);
            while (roots.hasMoreElements()) {
                URL url = roots.nextElement();
                String p = url.getProtocol();
                if ("file".equals(p)) {
                    String fp = URLDecoder.decode(url.getFile(), "UTF-8");
                    ResourceScaner.doScanByFile(new File(fp), path, filter, urls);
                    continue;
                }
                if (!"jar".equals(p)) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                ResourceScaner.doScanByJar(jar, path, filter, urls);
            }
        }
        catch (IOException ex) {
            EventBus.push(ex);
        }
        return urls;
    }

    private static void doScanByFile(File dir, String path, Predicate<String> filter, Set<String> urls) {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirfiles = dir.listFiles(f -> f.isDirectory() || filter.test(f.getName()));
        if (dirfiles != null) {
            for (File f2 : dirfiles) {
                String p2 = path + "/" + f2.getName();
                if (f2.isDirectory()) {
                    ResourceScaner.doScanByFile(f2, p2, filter, urls);
                    continue;
                }
                if (p2.startsWith("/")) {
                    urls.add(p2.substring(1));
                    continue;
                }
                urls.add(p2);
            }
        }
    }

    private static void doScanByJar(JarFile jar, String path, Predicate<String> filter, Set<String> urls) {
        Enumeration<JarEntry> entry = jar.entries();
        while (entry.hasMoreElements()) {
            JarEntry e = entry.nextElement();
            String n = e.getName();
            if (n.charAt(0) == '/') {
                n = n.substring(1);
            }
            if (e.isDirectory() || !n.startsWith(path) || !filter.test(n)) continue;
            if (n.startsWith("/")) {
                urls.add(n.substring(1));
                continue;
            }
            urls.add(n);
        }
    }
}

