/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Endpoint;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.Router;

public class RouterHandler
implements Handler {
    private Router router;

    public RouterHandler(Router router) {
        this.bind(router);
    }

    public void bind(Router router) {
        this.router = router;
    }

    @Override
    public void handle(Context context) throws Throwable {
        if (context.getHandled()) {
            return;
        }
        boolean _handled = false;
        this.handleMultiple(context, Endpoint.before);
        if (!context.getHandled()) {
            _handled = this.handleOne(context, Endpoint.main);
        }
        this.handleMultiple(context, Endpoint.after);
        if (_handled) {
            if (context.status() < 1) {
                context.statusSet(200);
            }
            context.setHandled(true);
        }
        if (context.status() < 1) {
            context.statusSet(404);
        }
    }

    protected boolean handleOne(Context context, Endpoint endpoint) throws Throwable {
        Handler handler = this.router.matchOne(context, endpoint);
        if (handler != null) {
            handler.handle(context);
            return context.status() != 404;
        }
        return false;
    }

    protected void handleMultiple(Context context, Endpoint endpoint) throws Throwable {
        for (Handler handler : this.router.matchAll(context, endpoint)) {
            handler.handle(context);
        }
    }
}

