/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathAnalyzer {
    private Pattern pattern;

    public PathAnalyzer(String path) {
        this.pattern = Pattern.compile(PathAnalyzer.expCompile(path), 2);
    }

    public Matcher matcher(String uri) {
        return this.pattern.matcher(uri);
    }

    public boolean matches(String uri) {
        return this.pattern.matcher(uri).find();
    }

    private static String expCompile(String path) {
        String p = path;
        p = p.replace(".", "\\.");
        p = p.replace("$", "\\$");
        p = p.replace("**", ".[]");
        if ((p = p.replace("*", "[^/]*")).indexOf("{") >= 0) {
            if (p.indexOf("_}") > 0) {
                p = p.replaceAll("\\{[^\\}]+?\\_\\}", "(.+?)");
            }
            p = p.replaceAll("\\{[^\\}]+?\\}", "([^/]+?)");
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        p = p.replace(".[]", ".*");
        return "^" + p + "$";
    }
}

