/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Note;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.ContextUtil;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.core.wrap.ClassWrap;

public abstract class Context {
    private boolean handled;
    private boolean rendered;
    private String protocolAsUpper;
    private String pathNew;
    private String pathAsUpper;
    private String accept;
    private String body;
    private String bodyNew;
    private SessionState sessionState;
    protected Charset charset = StandardCharsets.UTF_8;
    private String contentTypeNew;
    private Map<String, Object> attrMap = null;
    private boolean _remoting;
    @Note(value="\u5904\u7406\u7ed3\u679c")
    public Object result;
    @Note(value="\u5904\u7406\u9519\u8bef")
    public Throwable errors;

    @Note(value="\u83b7\u53d6\u5f53\u524d\u7ebf\u7a0b\u7684\u4e0a\u4e0b\u6587")
    public static Context current() {
        return ContextUtil.current();
    }

    @Note(value="\u8bbe\u7f6e\u5904\u7406\u72b6\u6001")
    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    @Note(value="\u83b7\u53d6\u5904\u7406\u72b6\u6001")
    public boolean getHandled() {
        return this.handled;
    }

    @Note(value="\u8bbe\u7f6e\u6e32\u67d3\u72b6\u6001")
    public void setRendered(boolean rendered) {
        this.rendered = rendered;
    }

    @Note(value="\u83b7\u53d6\u6e32\u67d3\u72b6\u6001")
    public boolean getRendered() {
        return this.rendered;
    }

    @Note(value="\u83b7\u53d6\u8bf7\u6c42\u5bf9\u8c61")
    public abstract Object request();

    @Note(value="\u83b7\u53d6\u8fdc\u7a0bIP")
    public abstract String ip();

    @Note(value="\u662f\u5426\u4e3a\u5206\u6bb5\u5185\u5bb9")
    public boolean isMultipart() {
        String temp = this.contentType();
        if (temp == null) {
            return false;
        }
        return temp.toLowerCase().contains("multipart/");
    }

    @Note(value="\u662f\u5426\u4e3a\u5206\u6bb5\u8868\u5355\u6570\u636e")
    public boolean isMultipartFormData() {
        String temp = this.contentType();
        if (temp == null) {
            return false;
        }
        return temp.toLowerCase().contains("multipart/form-data");
    }

    @Note(value="\u83b7\u53d6\u8bf7\u6c42\u65b9\u6cd5")
    public abstract String method();

    @Note(value="\u83b7\u53d6\u8bf7\u6c42\u534f\u8bae")
    public abstract String protocol();

    @Note(value="\u83b7\u53d6\u8bf7\u6c42\u534f\u8bae\u5e76\u5927\u5199")
    public String protocolAsUpper() {
        if (this.protocolAsUpper == null) {
            this.protocolAsUpper = this.protocol().toUpperCase();
        }
        return this.protocolAsUpper;
    }

    @Note(value="\u83b7\u53d6\u8bf7\u6c42\u7684URI")
    public abstract URI uri();

    @Note(value="\u83b7\u53d6\u8bf7\u6c42\u7684URI\u8def\u5f84")
    public abstract String path();

    public void pathNew(String pathNew) {
        this.pathNew = pathNew;
    }

    public String pathNew() {
        if (this.pathNew == null) {
            return this.path();
        }
        return this.pathNew;
    }

    @Note(value="\u83b7\u53d6\u8bf7\u6c42\u7684URI\u8def\u5f84\u53d8\u91cf,\u6839\u636e\u8def\u5f84\u8868\u8fbe\u5f0f")
    public NvMap pathMap(String expr) {
        return PathUtil.pathVarMap(this.path(), expr);
    }

    @Note(value="\u83b7\u53d6\u8bf7\u6c42\u7684URI\u8def\u5f84\u5e76\u5927\u5199")
    public String pathAsUpper() {
        if (this.pathAsUpper == null) {
            this.pathAsUpper = this.path().toUpperCase();
        }
        return this.pathAsUpper;
    }

    @Note(value="\u83b7\u53d6\u8bf7\u6c42\u7684UA")
    public String userAgent() {
        return this.header("User-Agent");
    }

    @Note(value="\u83b7\u53d6\u8bf7\u6c42\u7684URL\u5b57\u7b26\u4e32")
    public abstract String url();

    @Note(value="\u83b7\u53d6\u5185\u5bb9\u957f\u5ea6")
    public abstract long contentLength();

    @Note(value="\u83b7\u53d6\u5185\u5bb9\u7c7b\u578b")
    public abstract String contentType();

    @Note(value="\u83b7\u53d6\u67e5\u8be2\u5b57\u7b26\u4e32")
    public abstract String queryString();

    public String accept() {
        if (this.accept == null) {
            this.accept = this.header("Accept", "");
        }
        return this.accept;
    }

    @Note(value="\u83b7\u53d6RAW\u5185\u5bb9")
    public String body() throws IOException {
        return this.body(null);
    }

    @Note(value="\u83b7\u53d6RAW\u5185\u5bb9")
    public String body(String charset) throws IOException {
        if (this.body == null) {
            try (InputStream ins = this.bodyAsStream();){
                this.body = Utils.getString(ins, charset);
            }
        }
        return this.body;
    }

    public String bodyNew() throws IOException {
        if (this.bodyNew == null) {
            return this.body();
        }
        return this.bodyNew;
    }

    public void bodyNew(String bodyNew) {
        this.bodyNew = bodyNew;
    }

    @Note(value="\u83b7\u53d6RAW\u5185\u5bb9\u4e3abyte[]")
    public byte[] bodyAsBytes() throws IOException {
        try (InputStream ins = this.bodyAsStream();){
            if (ins == null) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayOutputStream outs = new ByteArrayOutputStream();
            int len = 0;
            byte[] buf = new byte[512];
            while ((len = ins.read(buf)) != -1) {
                outs.write(buf, 0, len);
            }
            byte[] byArray = outs.toByteArray();
            return byArray;
        }
    }

    @Note(value="\u83b7\u53d6RAW\u5185\u5bb9\u4e3aStream")
    public abstract InputStream bodyAsStream() throws IOException;

    @Note(value="\u83b7\u53d6\u53c2\u6570\u6570\u7ec4")
    public abstract String[] paramValues(String var1);

    @Note(value="\u83b7\u53d6\u53c2\u6570")
    public abstract String param(String var1);

    @Note(value="\u83b7\u53d6\u53c2\u6570")
    public abstract String param(String var1, String var2);

    @Note(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3aint")
    public int paramAsInt(String name) {
        return this.paramAsInt(name, 0);
    }

    @Note(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3aint")
    public int paramAsInt(String name, int def) {
        return Integer.parseInt(this.param(name, String.valueOf(def)));
    }

    @Note(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3along")
    public long paramAsLong(String name) {
        return this.paramAsLong(name, 0L);
    }

    @Note(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3along")
    public long paramAsLong(String name, long def) {
        return Long.parseLong(this.param(name, String.valueOf(def)));
    }

    @Note(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3adouble")
    public double paramAsDouble(String name) {
        return this.paramAsDouble(name, 0.0);
    }

    @Note(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3adouble")
    public double paramAsDouble(String name, double def) {
        return Double.parseDouble(this.param(name, String.valueOf(def)));
    }

    @Note(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3aBigDecimal")
    public BigDecimal paramAsDecimal(String name) {
        return this.paramAsDecimal(name, BigDecimal.ZERO);
    }

    @Note(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3aBigDecimal")
    public BigDecimal paramAsDecimal(String name, BigDecimal def) {
        String tmp = this.param(name);
        if (Utils.isEmpty(tmp)) {
            return def;
        }
        return new BigDecimal(tmp);
    }

    @Note(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3aBean")
    public <T> T paramAsBean(Class<T> type) {
        return ClassWrap.get(type).newBy(this::param, this);
    }

    @Note(value="\u83b7\u53d6\u6240\u6709\u53c2\u6570\u5e76\u8f6c\u4e3amap")
    public abstract NvMap paramMap();

    @Note(value="\u8bbe\u7f6e\u53c2\u6570")
    public void paramSet(String name, String val) {
        this.paramMap().put(name, val);
        this.paramsAdd(name, val);
    }

    @Note(value="\u83b7\u53d6\u6240\u6709\u53c2\u6570\u5e76\u8f6c\u4e3aMap")
    public abstract Map<String, List<String>> paramsMap();

    public void paramsAdd(String name, String val) {
        if (this.paramsMap() != null) {
            List<String> ary = this.paramsMap().get(name);
            if (ary == null) {
                ary = new ArrayList<String>();
                this.paramsMap().put(name, ary);
            }
            ary.add(val);
        }
    }

    @Note(value="\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6")
    public abstract List<UploadedFile> files(String var1) throws Exception;

    @Note(value="\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6")
    public UploadedFile file(String name) throws Exception {
        return Utils.firstOrNull(this.files(name));
    }

    @Note(value="\u83b7\u53d6COOKIE")
    public String cookie(String name) {
        return (String)this.cookieMap().get(name);
    }

    @Note(value="\u83b7\u53d6COOKIE")
    public String cookie(String name, String def) {
        return this.cookieMap().getOrDefault(name, def);
    }

    @Note(value="\u83b7\u53d6\u6240\u6709COOKIE\u5e76\u8f6c\u4e3amap")
    public abstract NvMap cookieMap();

    @Note(value="\u83b7\u53d6HEADER")
    public String header(String name) {
        return (String)this.headerMap().get(name);
    }

    @Note(value="\u83b7\u53d6HEADER")
    public String header(String name, String def) {
        return this.headerMap().getOrDefault(name, def);
    }

    @Note(value="\u83b7\u53d6\u6240\u6709HEADER\u5e76\u8f6c\u4e3amap")
    public abstract NvMap headerMap();

    protected void sessionStateInit(SessionState sessionState) {
        if (this.sessionState().replaceable()) {
            this.sessionState = sessionState;
        }
    }

    public SessionState sessionState() {
        if (this.sessionState == null) {
            this.sessionState = Bridge.sessionState(this);
        }
        return this.sessionState;
    }

    @Note(value="\u83b7\u53d6SESSION_ID")
    public final String sessionId() {
        return this.sessionState().sessionId();
    }

    @Note(value="\u83b7\u53d6SESSION\u72b6\u6001")
    public final Object session(String name) {
        return this.sessionState().sessionGet(name);
    }

    @Note(value="\u83b7\u53d6SESSION\u72b6\u6001")
    public final <T> T session(String name, T def) {
        Object tmp = this.session(name);
        if (tmp == null) {
            return def;
        }
        return (T)tmp;
    }

    @Note(value="\u8bbe\u7f6eSESSION\u72b6\u6001")
    public final void sessionSet(String name, Object val) {
        this.sessionState().sessionSet(name, val);
    }

    @Note(value="\u6e05\u7a7aSESSION\u72b6\u6001")
    public final void sessionClear() {
        this.sessionState().sessionClear();
    }

    @Note(value="\u83b7\u53d6\u8f93\u51fa\u5bf9\u8c61")
    public abstract Object response();

    @Note(value="\u8bbe\u7f6e\u5b57\u7b26\u96c6")
    public void charset(String charset) {
        this.charset = Charset.forName(charset);
    }

    @Note(value="\u8bbe\u7f6e\u5185\u5bb9\u7c7b\u578b")
    public void contentType(String contentType) {
        this.contentTypeDoSet(contentType);
        if (!"text/plain;charset=UTF-8".equals(contentType)) {
            this.contentTypeNew = contentType;
        }
    }

    @Note(value="\u83b7\u53d6\u8bbe\u7f6e\u7684\u5185\u5bb9\u7c7b\u578b")
    public String contentTypeNew() {
        return this.contentTypeNew;
    }

    protected abstract void contentTypeDoSet(String var1);

    @Note(value="\u8f93\u51fa\u5185\u5bb9:\u5b57\u8282\u6570\u7ec4")
    public abstract void output(byte[] var1);

    @Note(value="\u8f93\u51fa\u5185\u5bb9:stream")
    public abstract void output(InputStream var1);

    @Note(value="\u83b7\u53d6\u8f93\u51fa\u6d41")
    public abstract OutputStream outputStream() throws IOException;

    @Note(value="\u8f93\u51fa\u5185\u5bb9:\u5b57\u7b26\u4e32")
    public void output(String str) {
        if (str != null) {
            try {
                this.attrSet("output", str);
                this.output(str.getBytes(this.charset));
            }
            catch (Throwable ex) {
                throw Utils.throwableWrap(ex);
            }
        }
    }

    @Note(value="\u8f93\u51fa\u5185\u5bb9:\u5f02\u5e38\u5bf9\u8c61")
    public void output(Throwable ex) {
        this.output(Utils.getFullStackTrace(ex));
    }

    @Note(value="\u8f93\u51fajson")
    public void outputAsJson(String json) {
        this.contentType("application/json;charset=utf-8");
        this.output(json);
    }

    @Note(value="\u8f93\u51fahtml")
    public void outputAsHtml(String html) {
        this.contentType("text/html;charset=utf-8");
        if (!html.startsWith("<")) {
            StringBuilder sb = new StringBuilder();
            sb.append("<!doctype html>");
            sb.append("<html>");
            sb.append(html);
            sb.append("</html>");
            this.output(sb.toString());
        } else {
            this.output(html);
        }
    }

    @Note(value="\u8f93\u51fafile")
    public void outputAsFile(UploadedFile file) throws IOException {
        if (Utils.isNotEmpty(file.contentType)) {
            this.contentType(file.contentType);
        }
        if (Utils.isNotEmpty(file.name)) {
            this.headerSet("Content-Disposition", "attachment; filename=\"" + file.name + "\"");
        }
        Utils.transfer(file.content, this.outputStream());
    }

    @Note(value="\u8f93\u51fafile")
    public void outputAsFile(File file) throws IOException {
        if (Utils.isNotEmpty(file.getName())) {
            this.headerSet("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
        }
        try (FileInputStream ins = new FileInputStream(file);){
            Utils.transfer(ins, this.outputStream());
        }
    }

    @Note(value="\u8bbe\u7f6eHEADER")
    public abstract void headerSet(String var1, String var2);

    @Note(value="\u6dfb\u52a0HEADER")
    public abstract void headerAdd(String var1, String var2);

    @Note(value="\u8bbe\u7f6eCOOKIE")
    public void cookieSet(String name, String val) {
        this.cookieSet(name, val, null, -1);
    }

    @Note(value="\u8bbe\u7f6eCOOKIE")
    public void cookieSet(String name, String val, int maxAge) {
        this.cookieSet(name, val, null, maxAge);
    }

    @Note(value="\u8bbe\u7f6eCOOKIE")
    public void cookieSet(String name, String val, String domain, int maxAge) {
        this.cookieSet(name, val, domain, "/", maxAge);
    }

    @Note(value="\u8bbe\u7f6eCOOKIE")
    public abstract void cookieSet(String var1, String var2, String var3, String var4, int var5);

    @Note(value="\u79fb\u5f90COOKIE")
    public void cookieRemove(String name) {
        this.cookieSet(name, "", 0);
    }

    @Note(value="\u8df3\u8f6c\u5730\u5740")
    public abstract void redirect(String var1);

    @Note(value="\u8df3\u8f6c\u5730\u5740")
    public abstract void redirect(String var1, int var2);

    @Note(value="\u83b7\u53d6\u8f93\u51fa\u72b6\u6001")
    public abstract int status();

    @Deprecated
    public void status(int status) {
        this.statusSet(status);
    }

    @Note(value="\u8bbe\u7f6e\u8f93\u51fa\u72b6\u6001")
    public abstract void statusSet(int var1);

    @Note(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u7279\u6027\u5e76\u8f6c\u4e3aMap")
    public Map<String, Object> attrMap() {
        if (this.attrMap == null) {
            this.attrMap = new HashMap<String, Object>();
        }
        return this.attrMap;
    }

    @Note(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u7279\u6027")
    public <T> T attr(String name, T def) {
        Object val = this.attrMap().get(name);
        if (val == null) {
            return def;
        }
        return (T)val;
    }

    public <T> T attr(String name) {
        return (T)this.attrMap().get(name);
    }

    @Note(value="\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u7279\u6027")
    public void attrSet(String name, Object val) {
        this.attrMap().put(name, val);
    }

    @Note(value="\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u7279\u6027")
    public void attrSet(Map<String, Object> map) {
        this.attrMap().putAll(map);
    }

    @Note(value="\u6e05\u7a7a\u81ea\u5b9a\u4e49\u7279\u6027")
    public void attrClear() {
        this.attrMap().clear();
    }

    @Note(value="\u6e32\u67d3\u6570\u636e")
    public final void render(Object obj) throws Throwable {
        RenderManager.global.render(obj, this);
    }

    @Note(value="\u6e32\u67d3\u6570\u636e")
    public final void render(String view, Map<String, ?> data) throws Throwable {
        this.render(new ModelAndView(view, data));
    }

    @Note(value="\u6e32\u67d3\u6570\u636e")
    public final String renderAndReturn(ModelAndView modelAndView) throws Throwable {
        return RenderManager.global.renderAndReturn(modelAndView, this);
    }

    @Note(value="\u662f\u5426\u4e3a\u8fdc\u7a0b\u8c03\u7528")
    public boolean remoting() {
        return this._remoting;
    }

    public void remotingSet(boolean remote) {
        this._remoting = remote;
    }

    @Note(value="\u51b2\u5237")
    public abstract void flush() throws IOException;

    @Note(value="\u63d0\u4ea4\u54cd\u5e94")
    protected void commit() throws IOException {
    }

    @Note(value="\u5173\u95ed\u54cd\u5e94")
    public void close() throws IOException {
    }

    @Note(value="\u63a7\u5236\u5668?")
    public Object controller() {
        return this.attr("controller");
    }

    @Note(value="\u52a8\u4f5c?")
    public Action action() {
        return (Action)this.attr("action");
    }
}

