/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.Serializable;
import org.noear.solon.annotation.Note;

public class Result<T>
implements Serializable {
    public static int SUCCEED_CODE = 200;
    public static int FAILURE_CODE = 400;
    private int code;
    private String description;
    private T data;
    private static ResultReadonly _succeed;
    private static ResultReadonly _failure;

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public void setData(T data) {
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public Result(T data) {
        this.code = SUCCEED_CODE;
        this.description = "";
        this.data = data;
    }

    public Result(int code, String description) {
        this.code = code;
        this.description = description;
    }

    @Note(value="\u6210\u529f\u7684\u7a7a\u7ed3\u679c")
    public static <T> Result<T> succeed() {
        if (_succeed == null) {
            _succeed = new ResultReadonly(SUCCEED_CODE, "");
        }
        return _succeed;
    }

    @Note(value="\u6210\u529f\u7684\u7ed3\u679c")
    public static <T> Result<T> succeed(T data) {
        return new Result<T>(data);
    }

    @Note(value="\u5931\u8d25\u7684\u7a7a\u7ed3\u679c")
    public static <T> Result<T> failure() {
        if (_failure == null) {
            _failure = new ResultReadonly(FAILURE_CODE, "");
        }
        return _failure;
    }

    @Note(value="\u5931\u8d25\u7684\u7ed3\u679c")
    public static <T> Result<T> failure(int code) {
        return Result.failure(code, "");
    }

    @Note(value="\u5931\u8d25\u7684\u7ed3\u679c")
    public static <T> Result<T> failure(int code, String description) {
        return new Result<T>(code, description);
    }

    @Note(value="\u5931\u8d25\u7684\u7ed3\u679c")
    public static <T> Result<T> failure(String description) {
        return new Result<T>(FAILURE_CODE, description);
    }

    static class ResultReadonly<T>
    extends Result<T> {
        public ResultReadonly(T data) {
            super(data);
        }

        public ResultReadonly(int code, String description) {
            super(code, description);
        }

        @Override
        public void setCode(int code) {
            throw new RuntimeException("This result is readonly!");
        }

        @Override
        public void setData(T data) {
            throw new RuntimeException("This result is readonly!");
        }

        @Override
        public void setDescription(String description) {
            throw new RuntimeException("This result is readonly!");
        }
    }
}

